/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.types.IOpenField;
import org.openl.util.StringUtils;

public class DefaultFieldDescription
implements FieldDescription {
    private String canonicalTypeName;
    private Class<?> type;
    private String defaultValueAsString;
    private Object defaultValue;

    public DefaultFieldDescription(Class<?> type) {
        this(type, type.getCanonicalName());
    }

    public DefaultFieldDescription(IOpenField field) {
        this(field.getType().getInstanceClass(), field.getType().getInstanceClass().getCanonicalName());
    }

    private DefaultFieldDescription(Class<?> type, String canonicalTypeName) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null for the type declaration");
        }
        this.type = type;
        this.canonicalTypeName = canonicalTypeName;
    }

    @Override
    public String getCanonicalTypeName() {
        return this.canonicalTypeName;
    }

    public void setCanonicalTypeName(String canonicalTypeName) {
        this.canonicalTypeName = canonicalTypeName;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    @Override
    public void setDefaultValueAsString(String defaultValueAsString) {
        this.defaultValueAsString = defaultValueAsString;
    }

    @Override
    public boolean isArray() {
        if (this.getType().isArray()) {
            return true;
        }
        return this.canonicalTypeName.endsWith("]");
    }

    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.canonicalTypeName)) {
            return this.canonicalTypeName;
        }
        return super.toString();
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == null && this.defaultValueAsString != null) {
            if ("_DEFAULT_".equals(this.defaultValueAsString)) {
                this.defaultValue = "_DEFAULT_";
            } else {
                IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(this.getType());
                this.defaultValue = convertor.parse(this.defaultValueAsString, null);
            }
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean hasDefaultValue() {
        return StringUtils.isNotBlank((CharSequence)this.defaultValueAsString) && this.getDefaultValue() != null;
    }

    @Override
    public boolean hasDefaultKeyWord() {
        return this.hasDefaultValue() && "_DEFAULT_".equals(this.getDefaultValue());
    }
}

