/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;
import org.openl.util.generation.JavaClassGeneratorHelper;

public class ConstructorWithParametersWriter
extends DefaultBeanByteCodeWriter {
    public static final String INIT = "<init>";
    public static final String V = "()V";
    private Map<String, FieldDescription> parentFields;
    private Map<String, FieldDescription> allFields;
    private int twoStackElementFieldsCount;

    public ConstructorWithParametersWriter(String beanNameWithPackage, Class<?> parentClass, Map<String, FieldDescription> beanFields, Map<String, FieldDescription> parentFields, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, parentClass, beanFields);
        this.parentFields = new LinkedHashMap<String, FieldDescription>(parentFields);
        this.allFields = new LinkedHashMap<String, FieldDescription>(allFields);
        this.twoStackElementFieldsCount = ByteCodeGeneratorHelper.getTwoStackElementFieldsCount(allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        MethodVisitor methodVisitor;
        Constructor parentConstructor = null;
        if (this.getParentClass() != null) {
            parentConstructor = JavaClassGeneratorHelper.getConstructorByFieldsCount(this.getParentClass(), (int)this.parentFields.size());
        }
        int i = 1;
        int stackSizeForParentConstructorCall = 0;
        if (parentConstructor == null) {
            methodVisitor = classWriter.visitMethod(1, INIT, ByteCodeGeneratorHelper.getMethodSignatureForByteCode(this.getBeanFields(), null), null, null);
            methodVisitor.visitVarInsn(25, 0);
            String parentName = this.getParentInternalName();
            methodVisitor.visitMethodInsn(183, parentName, INIT, V);
        } else {
            methodVisitor = classWriter.visitMethod(1, INIT, ByteCodeGeneratorHelper.getMethodSignatureForByteCode(this.allFields, null), null, null);
            methodVisitor.visitVarInsn(25, 0);
            for (Map.Entry<String, FieldDescription> fieldEntry : this.parentFields.entrySet()) {
                FieldDescription field = fieldEntry.getValue();
                methodVisitor.visitVarInsn(ByteCodeGeneratorHelper.getConstantForVarInsn(field), i);
                if (Long.TYPE.equals(field.getType()) || Double.TYPE.equals(field.getType())) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            stackSizeForParentConstructorCall = i;
            methodVisitor.visitMethodInsn(183, Type.getInternalName(this.getParentClass()), INIT, ByteCodeGeneratorHelper.getMethodSignatureForByteCode(this.parentFields, null));
        }
        for (Map.Entry<String, FieldDescription> field : this.getBeanFields().entrySet()) {
            String fieldName = field.getKey();
            if (this.getParentClass() != null && this.parentFields.get(fieldName) != null) continue;
            FieldDescription fieldType = field.getValue();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(ByteCodeGeneratorHelper.getConstantForVarInsn(fieldType), i);
            methodVisitor.visitFieldInsn(181, this.getBeanNameWithPackage(), fieldName, ByteCodeGeneratorHelper.getJavaType(fieldType));
            if (Long.TYPE.equals(fieldType.getType()) || Double.TYPE.equals(fieldType.getType())) {
                i += 2;
                continue;
            }
            ++i;
        }
        methodVisitor.visitInsn(177);
        if (this.twoStackElementFieldsCount > 0) {
            methodVisitor.visitMaxs(3 + stackSizeForParentConstructorCall, this.allFields.size() + 1 + this.twoStackElementFieldsCount);
        } else {
            methodVisitor.visitMaxs(2 + stackSizeForParentConstructorCall, this.allFields.size() + 1);
        }
    }
}

