/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Date;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;
import org.openl.rules.datatype.gen.bean.writers.DefaultValue;
import org.openl.rules.datatype.gen.bean.writers.ISO8601DateFormater;

public class ProtectedFieldsWriter
extends DefaultBeanByteCodeWriter {
    public ProtectedFieldsWriter(Map<String, FieldDescription> beanFields) {
        super("", null, beanFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        for (Map.Entry<String, FieldDescription> field : this.getBeanFields().entrySet()) {
            String fieldTypeName = ByteCodeGeneratorHelper.getJavaType(field.getValue());
            FieldVisitor fieldVisitor = classWriter.visitField(4, field.getKey(), fieldTypeName, null, null);
            if (!field.getValue().hasDefaultValue()) continue;
            AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(Type.getDescriptor(DefaultValue.class), true);
            if (field.getValue().getType().equals(Date.class)) {
                Object value = field.getValue().getDefaultValue();
                if (value instanceof Date) {
                    Date date = (Date)value;
                    String formatedDate = ISO8601DateFormater.format(date);
                    annotationVisitor.visit("value", (Object)formatedDate);
                }
            } else {
                annotationVisitor.visit("value", (Object)field.getValue().getDefaultValueAsString());
            }
            annotationVisitor.visitEnd();
        }
    }
}

