/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.types.writers;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.types.writers.TypeWriter;

public class DefaultEmptyArrayConstructorTypeWriter
implements TypeWriter {
    @Override
    public int getConstantForVarInsn() {
        return 25;
    }

    @Override
    public int getConstantForReturn() {
        return 176;
    }

    private int findOptcodesForType(Class<?> type) {
        Type t = Type.getType(type);
        if (Type.BOOLEAN_TYPE.equals((Object)t)) {
            return 4;
        }
        if (Type.BYTE_TYPE.equals((Object)t)) {
            return 8;
        }
        if (Type.CHAR_TYPE.equals((Object)t)) {
            return 5;
        }
        if (Type.DOUBLE_TYPE.equals((Object)t)) {
            return 7;
        }
        if (Type.FLOAT_TYPE.equals((Object)t)) {
            return 6;
        }
        if (Type.INT_TYPE.equals((Object)t)) {
            return 10;
        }
        if (Type.LONG_TYPE.equals((Object)t)) {
            return 11;
        }
        if (Type.SHORT_TYPE.equals((Object)t)) {
            return 9;
        }
        throw new IllegalStateException("Primitive type wasn't found for code generation!");
    }

    @Override
    public int writeFieldValue(MethodVisitor methodVisitor, FieldDescription field) {
        if (!field.getType().isArray()) {
            throw new IllegalArgumentException("Field type is not an array!");
        }
        Class<?> type = field.getType().getComponentType();
        if (!type.isArray()) {
            String internalName = Type.getInternalName(type);
            methodVisitor.visitInsn(3);
            if (type.isPrimitive()) {
                methodVisitor.visitIntInsn(188, this.findOptcodesForType(type));
            } else {
                methodVisitor.visitTypeInsn(189, internalName);
            }
        } else {
            int level = 1;
            while (type.isArray()) {
                type = type.getComponentType();
                ++level;
            }
            String internalName = Type.getDescriptor(field.getType());
            for (int i = 0; i < level; ++i) {
                methodVisitor.visitInsn(3);
            }
            methodVisitor.visitMultiANewArrayInsn(internalName, level);
        }
        return 5;
    }
}

