/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2;

import java.util.Map;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.nodes.RangeNodeBuilder;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.types.IMethodCaller;

public class ConditionDescriptor {
    public boolean useIndexedValue;
    public ICondition condition;
    public IMethodCaller evaluator;

    public ConditionDescriptor(boolean useIndexedValue, ICondition condition) {
        this.useIndexedValue = useIndexedValue;
        this.condition = condition;
        this.evaluator = condition.getEvaluator();
    }

    public Object evaluate(DecisionTableSearchTree.SearchContext c) {
        return this.evaluator.invoke(c.target, c.params, c.env);
    }

    public boolean calculateCondition(int ruleN, DecisionTableSearchTree.SearchContext sc) {
        return this.condition.calculateCondition(ruleN, sc.target, sc.params, sc.env).getBooleanValue();
    }

    public static class WithRangeMap
    extends ConditionDescriptor {
        RangeNodeBuilder.IRangeIndexMap rangeMap;
        IRangeAdaptor rangeAdaptor;

        public WithRangeMap(boolean useIndexedValue, ICondition condition, RangeNodeBuilder.IRangeIndexMap rangeMap, IRangeAdaptor rangeAdaptor) {
            super(useIndexedValue, condition);
            this.rangeMap = rangeMap;
            this.rangeAdaptor = rangeAdaptor;
        }

        @Override
        public Object evaluate(DecisionTableSearchTree.SearchContext c) {
            Object x = this.evaluator.invoke(c.target, c.params, c.env);
            if (x == null) {
                return null;
            }
            if (this.rangeAdaptor != null) {
                x = this.rangeAdaptor.adaptValueType(x);
            }
            return this.rangeMap.findIndex(x);
        }
    }

    public static class WithMap
    extends ConditionDescriptor {
        Map<Object, Integer> map;

        public WithMap(boolean useIndexedValue, ICondition condition, Map<Object, Integer> map) {
            super(useIndexedValue, condition);
            this.map = map;
        }

        @Override
        public Object evaluate(DecisionTableSearchTree.SearchContext c) {
            Object key = this.evaluator.invoke(c.target, c.params, c.env);
            if (key == null) {
                return null;
            }
            return this.map.get(key);
        }
    }
}

