/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.nodes.BaseSearchNode;
import org.openl.rules.dt.algorithm2.nodes.NodesUtil;
import org.openl.rules.dt.element.ICondition;

public class DefaultSearchNodeRN
extends BaseSearchNode {
    List<ISearchTreeNode> nodes = new ArrayList<ISearchTreeNode>();
    List<NodesUtil.RuleRange> ranges = new ArrayList<NodesUtil.RuleRange>();

    @Override
    public ISearchTreeNode compactSearchNode() {
        int commonSize = this.ranges.size();
        ArrayList<Integer> rules = new ArrayList<Integer>(commonSize);
        for (int i = 0; i < this.ranges.size(); ++i) {
            this.nodes.set(i, this.nodes.get(i).compactSearchNode());
            rules.add(this.ranges.get((int)i).from);
        }
        Object intseq = NodesUtil.compactSequence(rules);
        if (intseq instanceof Integer) {
            return new SingleRN((Integer)intseq, this.nodes.get(0));
        }
        if (intseq instanceof NodesUtil.RuleRange) {
            return new RangeRN((NodesUtil.RuleRange)intseq, this.nodes.toArray(new ISearchTreeNode[0]));
        }
        return new ArrayRN((int[])intseq, this.nodes.toArray(new ISearchTreeNode[0]));
    }

    @Override
    public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        int n = this.ranges.size();
        for (int i = 0; i < n; ++i) {
            NodesUtil.RuleRange rr = this.ranges.get(i);
            if (!scxt.calculateCondition(rr.from)) continue;
            scxt.store(i);
            return this.nodes.get(i);
        }
        return null;
    }

    @Override
    public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        int n = this.ranges.size();
        for (int i = ((Integer)scxt.retrieve()).intValue(); i < n; ++i) {
            NodesUtil.RuleRange rr = this.ranges.get(i);
            if (!scxt.calculateCondition(rr.from)) continue;
            scxt.store(i);
            return this.nodes.get(i);
        }
        return null;
    }

    public ISearchTreeNode useLastNode(int ruleN, IndexInfo info, ICondition condition) {
        if (this.ranges.size() == 0) {
            return null;
        }
        NodesUtil.RuleRange rlast = this.ranges.get(this.ranges.size() - 1);
        if (ruleN != rlast.to + info.getStep()) {
            return null;
        }
        if (!condition.isEqual(rlast.to, ruleN)) {
            return null;
        }
        rlast.to = ruleN;
        return this.nodes.get(this.nodes.size() - 1);
    }

    public void addNewNode(int ruleN, ISearchTreeNode nextNode) {
        this.ranges.add(new NodesUtil.RuleRange(ruleN));
        this.nodes.add(nextNode);
    }

    static class ArrayRN
    extends BaseSearchNode.Compact {
        int[] ruleAry;
        ISearchTreeNode[] nodes;

        public ArrayRN(int[] ruleAry, ISearchTreeNode[] nodes) {
            this.ruleAry = ruleAry;
            this.nodes = nodes;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, 0);
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, (Integer)scxt.retrieve() + 1);
        }

        private Object findNodeOrValue(DecisionTableSearchTree.SearchContext scxt, int start) {
            for (int idx = start; idx <= this.ruleAry.length; ++idx) {
                if (!scxt.calculateCondition(this.ruleAry[idx])) continue;
                scxt.store(idx);
                return this.nodes[idx];
            }
            return null;
        }
    }

    static class RangeRN
    extends BaseSearchNode.Compact {
        NodesUtil.RuleRange ruleRange;
        ISearchTreeNode[] nodes;

        public RangeRN(NodesUtil.RuleRange ruleRange, ISearchTreeNode[] nodes) {
            this.ruleRange = ruleRange;
            this.nodes = nodes;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, 0);
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, (Integer)scxt.retrieve() + this.ruleRange.step);
        }

        private Object findNodeOrValue(DecisionTableSearchTree.SearchContext scxt, int step) {
            while (step < this.nodes.length) {
                int ruleN = this.ruleRange.from + step * this.ruleRange.step;
                if (scxt.calculateCondition(ruleN)) {
                    scxt.store(step);
                    return this.nodes[step];
                }
                ++step;
            }
            return null;
        }
    }

    static class SingleRN
    extends BaseSearchNode.CompactUnique {
        int ruleN;
        ISearchTreeNode node;

        public SingleRN(int ruleN, ISearchTreeNode node) {
            this.ruleN = ruleN;
            this.node = node;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return scxt.calculateCondition(this.ruleN) ? this.node : null;
        }
    }
}

