/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.nodes.BaseSearchNode;
import org.openl.rules.dt.algorithm2.nodes.NodesUtil;

public class DefaultSearchNodeRi
extends BaseSearchNode {
    List<Integer> rules = new ArrayList<Integer>();

    @Override
    public ISearchTreeNode compactSearchNode() {
        Object intseq = NodesUtil.compactSequence(this.rules);
        if (intseq instanceof Integer) {
            return new SingleRi((Integer)intseq);
        }
        if (intseq instanceof NodesUtil.RuleRange) {
            return new RangeRi((NodesUtil.RuleRange)intseq);
        }
        return new ArrayRi((int[])intseq);
    }

    @Override
    public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        for (int i = 0; i <= this.rules.size(); ++i) {
            int ruleN = this.rules.get(i);
            if (!scxt.calculateCondition(ruleN)) continue;
            scxt.store(i);
            return ruleN;
        }
        return null;
    }

    @Override
    public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        for (int i = ((Integer)scxt.retrieve()).intValue(); i <= this.rules.size(); ++i) {
            int ruleN = this.rules.get(i);
            if (!scxt.calculateCondition(ruleN)) continue;
            scxt.store(i);
            return ruleN;
        }
        return null;
    }

    public void addRule(int ruleN) {
        this.rules.add(ruleN);
    }

    static class ArrayRi
    extends BaseSearchNode.Compact {
        int[] ruleAry;

        public ArrayRi(int[] ruleAry) {
            this.ruleAry = ruleAry;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, 0);
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, (Integer)scxt.retrieve() + 1);
        }

        private Object findNodeOrValue(DecisionTableSearchTree.SearchContext scxt, int start) {
            for (int idx = start; idx <= this.ruleAry.length; ++idx) {
                if (!scxt.calculateCondition(this.ruleAry[idx])) continue;
                scxt.store(idx);
                return idx;
            }
            return null;
        }
    }

    static class RangeRi
    extends BaseSearchNode.Compact {
        NodesUtil.RuleRange ruleRange;

        public RangeRi(NodesUtil.RuleRange ruleRange) {
            this.ruleRange = ruleRange;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, this.ruleRange.from);
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.findNodeOrValue(scxt, (Integer)scxt.retrieve() + this.ruleRange.step);
        }

        private Object findNodeOrValue(DecisionTableSearchTree.SearchContext scxt, int start) {
            for (int ruleN = start; ruleN <= this.ruleRange.to; ruleN += this.ruleRange.step) {
                if (!scxt.calculateCondition(ruleN)) continue;
                scxt.store(ruleN);
                return ruleN;
            }
            return null;
        }
    }

    static class SingleRi
    extends BaseSearchNode.CompactUnique {
        int ruleN;

        public SingleRi(int ruleN) {
            this.ruleN = ruleN;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return scxt.calculateCondition(this.ruleN) ? Integer.valueOf(this.ruleN) : null;
        }
    }
}

