/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.nodes.BaseSearchNode;
import org.openl.rules.dt.algorithm2.nodes.NodesUtil;
import org.openl.rules.dt.element.ICondition;

public class EmptySearchNodeRN
extends BaseSearchNode {
    List<ISearchTreeNode> nodes = new ArrayList<ISearchTreeNode>();
    List<NodesUtil.RuleRange> ranges = new ArrayList<NodesUtil.RuleRange>();

    @Override
    public ISearchTreeNode compactSearchNode() {
        int commonSize = this.ranges.size();
        ArrayList<Integer> rules = new ArrayList<Integer>(commonSize);
        for (int i = 0; i < this.ranges.size(); ++i) {
            this.nodes.set(i, this.nodes.get(i).compactSearchNode());
            rules.add(this.ranges.get((int)i).from);
        }
        Object intseq = NodesUtil.compactSequence(rules);
        if (intseq instanceof Integer) {
            return new SingleRN(this.nodes.get(0));
        }
        return new ArrayRN(this.nodes.toArray(new ISearchTreeNode[0]));
    }

    @Override
    public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        int n = this.ranges.size();
        for (int i = 0; i < n; ++i) {
            NodesUtil.RuleRange rr = this.ranges.get(i);
            if (!scxt.calculateCondition(rr.from)) continue;
            scxt.store(i);
            return this.nodes.get(i);
        }
        return null;
    }

    @Override
    public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        int n = this.ranges.size();
        for (int i = ((Integer)scxt.retrieve()).intValue(); i < n; ++i) {
            NodesUtil.RuleRange rr = this.ranges.get(i);
            if (!scxt.calculateCondition(rr.from)) continue;
            scxt.store(i);
            return this.nodes.get(i);
        }
        return null;
    }

    public ISearchTreeNode useLastNode(int ruleN, IndexInfo info, ICondition condition) {
        NodesUtil.RuleRange rlast = this.ranges.get(this.ranges.size() - 1);
        if (ruleN != rlast.to + info.getStep()) {
            return null;
        }
        rlast.to = ruleN;
        return this.nodes.get(this.nodes.size() - 1);
    }

    public void addNewNode(int ruleN, ISearchTreeNode nextNode) {
        this.ranges.add(new NodesUtil.RuleRange(ruleN));
        this.nodes.add(nextNode);
    }

    static class ArrayRN
    extends BaseSearchNode.Compact {
        ISearchTreeNode[] nodes;

        public ArrayRN(ISearchTreeNode[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            scxt.store(0);
            return this.nodes[0];
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            int idx = (Integer)scxt.retrieve() + 1;
            if (idx < this.nodes.length) {
                scxt.store(idx);
                return this.nodes[idx];
            }
            return null;
        }
    }

    static class RangeRN
    extends BaseSearchNode.Compact {
        NodesUtil.RuleRange ruleRange;
        ISearchTreeNode[] nodes;

        public RangeRN(NodesUtil.RuleRange ruleRange, ISearchTreeNode[] nodes) {
            this.ruleRange = ruleRange;
            this.nodes = nodes;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            scxt.store(0);
            return this.nodes[0];
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            int idx = (Integer)scxt.retrieve() + this.ruleRange.step;
            if (idx < this.ruleRange.to) {
                scxt.store(idx);
                return this.nodes[idx];
            }
            return null;
        }
    }

    static class SingleRN
    extends BaseSearchNode.Unique {
        ISearchTreeNode node;

        public SingleRN(ISearchTreeNode node) {
            this.node = node;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.node;
        }

        @Override
        public ISearchTreeNode compactSearchNode() {
            this.node = this.node.compactSearchNode();
            return this;
        }
    }
}

