/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.dt.algorithm2.DecisionTableSearchTree;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.nodes.BaseSearchNode;
import org.openl.rules.dt.algorithm2.nodes.NodesUtil;

public class EmptySearchNodeRi
extends BaseSearchNode {
    List<Integer> rules = new ArrayList<Integer>();

    @Override
    public ISearchTreeNode compactSearchNode() {
        Object intseq = NodesUtil.compactSequence(this.rules);
        if (intseq instanceof Integer) {
            return new SingleRi((Integer)intseq);
        }
        if (intseq instanceof NodesUtil.RuleRange) {
            return new RangeRi((NodesUtil.RuleRange)intseq);
        }
        return new ArrayRi((int[])intseq);
    }

    @Override
    public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
        throw new UnsupportedOperationException();
    }

    public void addRule(int ruleN) {
        this.rules.add(ruleN);
    }

    static class ArrayRi
    extends BaseSearchNode.Compact {
        int[] ruleAry;

        public ArrayRi(int[] ruleAry) {
            this.ruleAry = ruleAry;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            scxt.store(0);
            return this.ruleAry[0];
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            int idx = (Integer)scxt.retrieve() + 1;
            if (idx >= this.ruleAry.length) {
                return null;
            }
            scxt.store(idx);
            return this.ruleAry[idx];
        }
    }

    static class RangeRi
    extends BaseSearchNode.Compact {
        NodesUtil.RuleRange ruleRange;

        public RangeRi(NodesUtil.RuleRange ruleRange) {
            this.ruleRange = ruleRange;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            scxt.store(this.ruleRange.from);
            return this.ruleRange.from;
        }

        @Override
        public Object findNextNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            int ruleN = (Integer)scxt.retrieve() + this.ruleRange.step;
            if (ruleN >= this.ruleRange.to) {
                return null;
            }
            scxt.store(ruleN);
            return ruleN;
        }
    }

    static class SingleRi
    extends BaseSearchNode.CompactUnique {
        int ruleN;

        public SingleRi(int ruleN) {
            this.ruleN = ruleN;
        }

        @Override
        public Object findFirstNodeOrValue(DecisionTableSearchTree.SearchContext scxt) {
            return this.ruleN;
        }
    }
}

