/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.builder;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.dt.builder.ArrayConditionBuilder;
import org.openl.rules.dt.builder.IDecisionTableColumnBuilder;
import org.openl.rules.dt.builder.SimpleConditionBuilder;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.validation.properties.dimentional.IDecisionTableColumn;

public class ConditionsBuilder
implements IDecisionTableColumnBuilder {
    private List<IDecisionTableColumnBuilder> conditionBuilders;

    public ConditionsBuilder(List<IDecisionTableColumn> conditions) {
        this.initConditionBuilders(conditions);
    }

    @Override
    public int build(IWritableGrid sheet, int numberOfRules, int columnStartIndex, int rowStartIndex) {
        int nextColumn = columnStartIndex;
        for (IDecisionTableColumnBuilder conditionBuilder : this.conditionBuilders) {
            int columnUsedForCondition = conditionBuilder.build(sheet, numberOfRules, nextColumn, rowStartIndex);
            nextColumn += columnUsedForCondition;
        }
        return nextColumn;
    }

    private void initConditionBuilders(List<IDecisionTableColumn> conditions) {
        int conditionsNumber = 0;
        this.conditionBuilders = new ArrayList<IDecisionTableColumnBuilder>();
        for (int i = 0; i < conditions.size(); ++i) {
            if (conditions.get(i).getNumberOfLocalParameters() <= 0) continue;
            ++conditionsNumber;
            if (conditions.get(i).getNumberOfLocalParameters() > 1) {
                this.conditionBuilders.add(new ArrayConditionBuilder(conditions.get(i), conditionsNumber));
                continue;
            }
            this.conditionBuilders.add(new SimpleConditionBuilder(conditions.get(i), conditionsNumber));
        }
    }
}

