/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.storage.IIntStorage;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.StorageInfo;

public class SimpleIntStorage
implements IStorage {
    StorageInfo info;
    static final Convertor<Byte, Integer> Byte2Integer = new Convertor<Byte, Integer>(){

        @Override
        public Integer convertWrite(Byte from) {
            return from.intValue();
        }

        @Override
        public Byte convertRead(Integer to) {
            return to.byteValue();
        }
    };
    static final Convertor<Short, Integer> Short2Integer = new Convertor<Short, Integer>(){

        @Override
        public Integer convertWrite(Short from) {
            return from.intValue();
        }

        @Override
        public Short convertRead(Integer to) {
            return to.shortValue();
        }
    };
    Convertor convertor;
    IIntStorage storage;

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public Object getValue(int index) {
        return this.storage.getNativeValue(index);
    }

    @Override
    public boolean isSpace(int index) {
        return false;
    }

    @Override
    public boolean isFormula(int index) {
        return false;
    }

    @Override
    public boolean isElse(int index) {
        return false;
    }

    @Override
    public void setValue(int index, Object o) {
        this.storage.setNativeValue(index, this.convertor.convertWrite(o));
    }

    @Override
    public void setSpace(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setElse(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormula(int index, Object formula) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StorageInfo getInfo() {
        return this.info;
    }

    public void setInfo(StorageInfo info) {
        this.info = info;
    }

    static interface Convertor<From, To> {
        public To convertWrite(From var1);

        public From convertRead(To var1);
    }
}

