/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.openl.meta.DoubleValue;
import org.openl.rules.helpers.DoubleRangeParser;
import org.openl.rules.helpers.INumberRange;
import org.openl.util.RangeWithBounds;

@XmlRootElement
public class DoubleRange
implements INumberRange {
    private double lowerBound;
    private double upperBound;
    private RangeWithBounds.BoundType lowerBoundType;
    private RangeWithBounds.BoundType upperBoundType;

    public DoubleRange(double lowerBound, double upperBound) {
        this(lowerBound, upperBound, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
    }

    public DoubleRange(double lowerBound, double upperBound, RangeWithBounds.BoundType lowerBoundType, RangeWithBounds.BoundType upperBoundType) {
        if (lowerBound > upperBound) {
            throw new RuntimeException(upperBound + " must be more or equal than " + lowerBound);
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerBoundType = lowerBoundType;
        this.upperBoundType = upperBoundType;
    }

    public DoubleRange() {
        this.lowerBound = 0.0;
        this.upperBound = 0.0;
    }

    public DoubleRange(String range) {
        RangeWithBounds res = DoubleRange.getRangeWithBounds(range);
        this.lowerBound = res.getMin().doubleValue();
        this.lowerBoundType = res.getLeftBoundType();
        this.upperBound = res.getMax().doubleValue();
        this.upperBoundType = res.getRightBoundType();
        if (DoubleRange.isTruncated(res.getMin(), this.lowerBound)) {
            throw new IllegalArgumentException("lowerBound value is truncated");
        }
        if (DoubleRange.isTruncated(res.getMax(), this.upperBound)) {
            throw new IllegalArgumentException("upperBound value is truncated");
        }
    }

    public static RangeWithBounds getRangeWithBounds(String range) {
        return DoubleRangeParser.getInstance().parse(range);
    }

    protected static boolean isTruncated(Number from, double to) {
        return from instanceof BigDecimal && Double.isInfinite(to);
    }

    public int compareLowerBound(DoubleRange range) {
        if (this.lowerBound < range.lowerBound) {
            return -1;
        }
        if (this.lowerBound == range.lowerBound) {
            if (this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING && range.lowerBoundType == RangeWithBounds.BoundType.EXCLUDING) {
                return -1;
            }
            if (this.lowerBoundType == range.lowerBoundType) {
                return 0;
            }
        }
        return 1;
    }

    public int compareUpperBound(DoubleRange range) {
        if (this.upperBound < range.upperBound) {
            return -1;
        }
        if (this.upperBound == range.upperBound) {
            if (this.upperBoundType == RangeWithBounds.BoundType.INCLUDING && range.upperBoundType == RangeWithBounds.BoundType.EXCLUDING) {
                return -1;
            }
            if (this.upperBoundType == range.upperBoundType) {
                return 0;
            }
        }
        return 1;
    }

    public boolean contains(double x) {
        if (this.lowerBound < x && x < this.upperBound) {
            return true;
        }
        if (x == this.lowerBound && this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING) {
            return true;
        }
        return x == this.upperBound && this.upperBoundType == RangeWithBounds.BoundType.INCLUDING;
    }

    public boolean contains(DoubleValue value) {
        return this.contains(value.doubleValue());
    }

    public boolean contains(DoubleRange range) {
        return this.compareLowerBound(range) <= 0 && this.compareUpperBound(range) >= 0;
    }

    @Override
    public boolean containsNumber(Number num) {
        return this.contains(num.doubleValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleRange)) {
            return false;
        }
        DoubleRange other = (DoubleRange)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.lowerBound, other.lowerBound);
        builder.append(this.upperBound, other.upperBound);
        builder.append((Object)this.upperBoundType, (Object)other.upperBoundType);
        builder.append((Object)this.upperBoundType, (Object)other.upperBoundType);
        return builder.isEquals();
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public DoubleRange intersect(DoubleRange range) {
        int lowerBoundComaring = this.compareLowerBound(range);
        int upperBoundComaring = this.compareUpperBound(range);
        double lowerBound = lowerBoundComaring > 0 ? this.lowerBound : range.lowerBound;
        RangeWithBounds.BoundType lowerBoundType = lowerBoundComaring > 0 ? this.lowerBoundType : range.lowerBoundType;
        double upperBound = upperBoundComaring < 0 ? this.upperBound : range.upperBound;
        RangeWithBounds.BoundType upperBoundType = upperBoundComaring < 0 ? this.upperBoundType : range.upperBoundType;
        return lowerBound > upperBound ? null : new DoubleRange(lowerBound, upperBound, lowerBoundType, upperBoundType);
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public RangeWithBounds.BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    public void setLowerBoundType(RangeWithBounds.BoundType lowerBoundType) {
        this.lowerBoundType = lowerBoundType;
    }

    public RangeWithBounds.BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    public void setUpperBoundType(RangeWithBounds.BoundType upperBoundType) {
        this.upperBoundType = upperBoundType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING) {
            builder.append('[');
        } else {
            builder.append('(');
        }
        builder.append(this.lowerBound).append("; ").append(this.upperBound);
        if (this.upperBoundType == RangeWithBounds.BoundType.INCLUDING) {
            builder.append(']');
        } else {
            builder.append(')');
        }
        return builder.toString();
    }
}

