/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IUserContext;
import org.openl.rules.lang.xls.BaseParser;
import org.openl.rules.lang.xls.IncludeSearcher;
import org.openl.rules.lang.xls.XlsLoader;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.util.PropertiesLocator;

public class XlsParser
extends BaseParser {
    private static final String SEARCH_PROPERTY_NAME = "org.openl.rules.include";
    private static final String SEARCH_FILE_NAME = "org/openl/rules/org.openl.rules.include.properties";
    private IUserContext userContext;
    private String searchPath;

    public XlsParser(IUserContext userContext) {
        this.userContext = userContext;
    }

    protected String getSearchPath(IConfigurableResourceContext resourceContext) {
        if (this.searchPath == null) {
            this.searchPath = PropertiesLocator.findPropertyValue((String)SEARCH_PROPERTY_NAME, (String)SEARCH_FILE_NAME, (IConfigurableResourceContext)resourceContext);
        }
        return this.searchPath;
    }

    @Override
    public IParsedCode parseAsModule(IOpenSourceCodeModule source) {
        IncludeSearcher includeSeeker = this.getIncludeSeeker();
        XlsLoader xlsLoader = new XlsLoader(includeSeeker, this.userContext);
        return xlsLoader.parse(source);
    }

    private IncludeSearcher getIncludeSeeker() {
        ConfigurableResourceContext resourceContext = new ConfigurableResourceContext(this.userContext.getUserClassLoader(), new String[]{this.userContext.getUserHome()});
        String searchPath = this.getSearchPath((IConfigurableResourceContext)resourceContext);
        return new IncludeSearcher((IConfigurableResourceContext)resourceContext, searchPath);
    }

    @Override
    protected IParsedCode getNotSupportedCode(IOpenSourceCodeModule source, String sourceType) {
        String message = String.format(".xls files can not be parsed as %s", sourceType);
        return this.getInvalidCode(message, source);
    }
}

