/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.XlsWorkbookListener;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoaders;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.ASourceCodeModule;
import org.openl.source.impl.SourceCodeModuleDelegator;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.util.FileUtils;
import org.openl.util.IOUtils;
import org.openl.util.StringTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsWorkbookSourceCodeModule
extends SourceCodeModuleDelegator {
    private final Logger log = LoggerFactory.getLogger(XlsWorkbookSourceCodeModule.class);
    public final ModificationChecker DEFAULT_MODIDFICATION_CHECKER = new ModificationChecker(){

        @Override
        public boolean isModified() {
            return XlsWorkbookSourceCodeModule.super.isModified();
        }
    };
    private WorkbookLoader workbookLoader;
    private Set<Short> wbColors = new TreeSet<Short>();
    private Collection<XlsWorkbookListener> listeners = new ArrayList<XlsWorkbookListener>();
    private ModificationChecker modificationChecker = this.DEFAULT_MODIDFICATION_CHECKER;
    private final Object fileAccessLock = new Object();

    public XlsWorkbookSourceCodeModule(IOpenSourceCodeModule src) {
        this(src, WorkbookLoaders.getWorkbookLoader(src));
    }

    public XlsWorkbookSourceCodeModule(IOpenSourceCodeModule src, WorkbookLoader workbookLoader) {
        super(src);
        this.workbookLoader = workbookLoader;
    }

    private void initWorkbookColors() {
        if (!(this.getWorkbook() instanceof HSSFWorkbook)) {
            return;
        }
        Workbook workbook = this.getWorkbook();
        short numStyles = workbook.getNumCellStyles();
        for (short i = 0; i < numStyles; i = (short)(i + 1)) {
            CellStyle cellStyle = workbook.getCellStyleAt(i);
            this.wbColors.add(cellStyle.getFillForegroundColor());
            this.wbColors.add(cellStyle.getFillBackgroundColor());
            this.wbColors.add(cellStyle.getTopBorderColor());
            this.wbColors.add(cellStyle.getBottomBorderColor());
            this.wbColors.add(cellStyle.getLeftBorderColor());
            this.wbColors.add(cellStyle.getRightBorderColor());
        }
        short numFonts = workbook.getNumberOfFonts();
        for (short i = 0; i < numFonts; i = (short)(i + 1)) {
            Font font = workbook.getFontAt(i);
            this.wbColors.add(font.getColor());
        }
    }

    public void addListener(XlsWorkbookListener listener) {
        this.listeners.add(listener);
    }

    public Collection<XlsWorkbookListener> getListeners() {
        return this.listeners;
    }

    public String getDisplayName() {
        String uri = StringTool.decodeURL((String)this.src.getUri());
        return FileUtils.getName((String)uri);
    }

    public String getUri() {
        return this.src.getUri();
    }

    public Workbook getWorkbook() {
        return this.workbookLoader.getWorkbook();
    }

    public WorkbookLoader getWorkbookLoader() {
        return this.workbookLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getSourceFile() {
        Object object = this.fileAccessLock;
        synchronized (object) {
            File sourceFile = null;
            try {
                if (this.src instanceof URLSourceCodeModule) {
                    URL url = ((URLSourceCodeModule)this.src).getUrl();
                    sourceFile = new File(url.toURI());
                } else {
                    URI uri = new URI(this.getUri());
                    sourceFile = new File(uri);
                }
            }
            catch (URISyntaxException me) {
                this.log.warn("Can not get source file");
            }
            return sourceFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        File sourceFile = this.getSourceFile();
        String fileName = sourceFile.getCanonicalPath();
        Object object = this.fileAccessLock;
        synchronized (object) {
            this.saveAs(fileName);
            this.resetModified();
        }
    }

    public ModificationChecker getModificationChecker() {
        return this.modificationChecker;
    }

    public void setModificationChecker(ModificationChecker modificationChecker) {
        this.modificationChecker = modificationChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Object object = this.fileAccessLock;
        synchronized (object) {
            return this.modificationChecker.isModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModified() {
        Object object = this.fileAccessLock;
        synchronized (object) {
            if (this.getSource() instanceof ASourceCodeModule) {
                ((ASourceCodeModule)this.getSource()).resetModified();
            }
        }
    }

    public void saveAs(String fileName) throws IOException {
        for (XlsWorkbookListener wl : this.listeners) {
            wl.beforeSave(this);
        }
        DeferredCreateFileOutputStream fileOut = new DeferredCreateFileOutputStream(fileName);
        this.getWorkbook().write((OutputStream)fileOut);
        ((OutputStream)fileOut).close();
        for (XlsWorkbookListener wl : this.listeners) {
            wl.afterSave(this);
        }
    }

    public IOpenSourceCodeModule getSource() {
        return this.src;
    }

    public Set<Short> getWorkbookColors() {
        if (this.wbColors.isEmpty()) {
            this.initWorkbookColors();
        }
        return this.wbColors;
    }

    private static final class DeferredCreateFileOutputStream
    extends OutputStream {
        private final String fileName;
        private OutputStream stream;

        private DeferredCreateFileOutputStream(String fileName) throws FileNotFoundException {
            this.fileName = fileName;
            this.throwExceptionIfNotWritable(fileName);
        }

        private void throwExceptionIfNotWritable(String fileName) throws FileNotFoundException {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(fileName, true);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)os);
        }

        private OutputStream getStream() throws FileNotFoundException {
            if (this.stream == null) {
                this.stream = new FileOutputStream(this.fileName);
            }
            return this.stream;
        }

        @Override
        public void write(int idx) throws IOException {
            this.getStream().write(idx);
        }

        @Override
        public void write(byte[] bts) throws IOException {
            this.getStream().write(bts);
        }

        @Override
        public void write(byte[] bts, int st, int end) throws IOException {
            this.getStream().write(bts, st, end);
        }

        @Override
        public void flush() throws IOException {
            if (this.stream != null) {
                this.stream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    public static interface ModificationChecker {
        public boolean isModified();
    }
}

