/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.ObjectUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IMemberBoundNode;
import org.openl.engine.OpenLManager;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.StringUtils;
import org.openl.util.text.TextInfo;

public abstract class AExecutableNodeBinder
extends AXlsTableBinder {
    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        OpenMethodHeader header = this.createHeader(tableSyntaxNode, openl, bindingContext);
        header.setDeclaringClass((IOpenClass)module);
        this.checkForDuplicates(tableSyntaxNode, (RulesModuleBindingContext)bindingContext, header);
        return this.createNode(tableSyntaxNode, openl, header, module);
    }

    public IOpenSourceCodeModule createHeaderSource(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) throws SyntaxNodeException {
        IGridTable table = tableSyntaxNode.getGridTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table, bindingContext);
        SubTextSourceCodeModule headerSource = new SubTextSourceCodeModule((IOpenSourceCodeModule)source, tableSyntaxNode.getHeader().getHeaderToken().getSourceLocation().getEnd().getAbsolutePosition(new TextInfo(source.getCode())));
        return headerSource;
    }

    public OpenMethodHeader createHeader(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext) throws SyntaxNodeException {
        IOpenSourceCodeModule headerSource = this.createHeaderSource(tableSyntaxNode, bindingContext);
        IBindingContextDelegator bindingContextDelegator = (IBindingContextDelegator)bindingContext;
        return (OpenMethodHeader)OpenLManager.makeMethodHeader((OpenL)openl, (IOpenSourceCodeModule)headerSource, (IBindingContextDelegator)bindingContextDelegator);
    }

    protected abstract IMemberBoundNode createNode(TableSyntaxNode var1, OpenL var2, OpenMethodHeader var3, XlsModuleOpenClass var4);

    private void checkForDuplicates(TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext bindingContext, OpenMethodHeader header) throws DuplicatedTableException {
        String key = this.makeKey(tableSyntaxNode, header);
        if (bindingContext.isTableSyntaxNodeExist(key)) {
            throw new DuplicatedTableException(tableSyntaxNode.getDisplayName(), bindingContext.getTableSyntaxNode(key), tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private String makeKey(TableSyntaxNode tableSyntaxNode, OpenMethodHeader header) {
        StringBuilder builder = new StringBuilder();
        builder.append(header.getName());
        ArrayList<String> names = new ArrayList<String>();
        for (IOpenClass parameter : header.getSignature().getParameterTypes()) {
            names.add(parameter.getName());
        }
        builder.append("(").append(StringUtils.join(names, (String)", ")).append(")");
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String property : TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames()) {
            values.add(tableProperties.getPropertyValue(property));
        }
        builder.append("[").append(AExecutableNodeBinder.join(values, ", ")).append(tableProperties.getVersion()).append("]");
        return builder.toString();
    }

    static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(first);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            if (obj.getClass().isArray()) {
                buf.append(Arrays.toString((Object[])obj));
                continue;
            }
            buf.append(obj);
        }
        return buf.toString();
    }
}

