/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.ArrayList;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.meta.IMetaInfo;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ICell;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.MethodDelegator;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;
import org.openl.vm.IRuntimeEnv;

public abstract class AMethodBasedNode
extends ATableBoundNode
implements IMemberBoundNode {
    private OpenL openl;
    private IOpenMethodHeader header;
    private ExecutableRulesMethod method;
    private ModuleOpenClass module;

    public AMethodBasedNode(TableSyntaxNode methodNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(methodNode, new IBoundNode[0]);
        this.header = header;
        this.openl = openl;
        this.module = module;
    }

    public OpenL getOpenl() {
        return this.openl;
    }

    public IOpenMethodHeader getHeader() {
        return this.header;
    }

    public ExecutableRulesMethod getMethod() {
        return this.method;
    }

    public ModuleOpenClass getModule() {
        return this.module;
    }

    public boolean isLiteralExpressionParent() {
        return false;
    }

    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        throw new UnsupportedOperationException("Should not be called");
    }

    public IOpenClass getType() {
        return this.header.getType();
    }

    public void addTo(ModuleOpenClass openClass) {
        this.method = this.createMethodShell();
        openClass.addMethod((IOpenMethod)this.method);
        this.getTableSyntaxNode().setMember((IOpenMember)this.method);
        if (this.hasServiceName()) {
            this.addServiceMethod(openClass, (IOpenMethod)this.method);
        }
    }

    protected boolean hasServiceName() {
        return StringUtils.isNotBlank((CharSequence)this.getTableSyntaxNode().getTableProperties().getId());
    }

    protected IOpenMethod getServiceMethod(IOpenMethod originalMethod) {
        final String serviceMethodName = this.getTableSyntaxNode().getTableProperties().getId();
        return new MethodDelegator((IMethodCaller)originalMethod){

            public String getName() {
                return serviceMethodName;
            }

            public String getDisplayName(int mode) {
                return serviceMethodName;
            }
        };
    }

    protected void addServiceMethod(ModuleOpenClass openClass, IOpenMethod originalMethod) {
        try {
            openClass.addMethod(this.getServiceMethod(originalMethod));
        }
        catch (DuplicatedMethodException e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(null, (Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
            this.getTableSyntaxNode().addError(error);
            OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
        }
    }

    protected abstract ExecutableRulesMethod createMethodShell();

    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode()) {
            this.getMethod().setBoundNode(null);
            this.getMethod().getMethodProperties().setModulePropertiesTable(null);
            this.getMethod().getMethodProperties().setCategoryPropertiesTable(null);
            this.getMethod().getMethodProperties().setPropertiesSection(null);
        }
    }

    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        if (!bindingContext.isExecutionMode() && this.header instanceof OpenMethodHeader) {
            ILocation[] paramTypeLocations;
            OpenMethodHeader tableHeader = (OpenMethodHeader)this.header;
            ArrayList<SimpleNodeUsage> nodeUsages = new ArrayList<SimpleNodeUsage>();
            ICell cell = this.getTableSyntaxNode().getGridTable().getCell(0, 0);
            TextInfo tableHeaderText = new TextInfo(cell.getStringValue());
            int startPosition = this.getSignatureStartIndex();
            IOpenClass type = tableHeader.getType();
            IMetaInfo metaInfo = type.getMetaInfo();
            while (metaInfo == null && type.isArray()) {
                type = type.getComponentClass();
                metaInfo = type.getMetaInfo();
            }
            GridCellSourceCodeModule src = new GridCellSourceCodeModule(this.getTableSyntaxNode().getGridTable(), bindingContext);
            SubTextSourceCodeModule headerSyntaxNode = new SubTextSourceCodeModule((IOpenSourceCodeModule)src, startPosition, src.getCode().length());
            ILocation typeLocation = tableHeader.getTypeLocation();
            if (metaInfo != null && typeLocation != null) {
                int start = startPosition + typeLocation.getStart().getAbsolutePosition(tableHeaderText);
                int end = startPosition + typeLocation.getEnd().getAbsolutePosition(tableHeaderText);
                nodeUsages.add(new SimpleNodeUsage(start, end, metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), NodeType.DATATYPE));
                if (type.getInstanceClass() == null) {
                    this.addTypeError(type, typeLocation, (IOpenSourceCodeModule)headerSyntaxNode);
                }
            }
            if ((paramTypeLocations = tableHeader.getParamTypeLocations()) != null) {
                for (int i = 0; i < this.header.getSignature().getNumberOfParameters(); ++i) {
                    IOpenClass parameterType = this.header.getSignature().getParameterType(i);
                    metaInfo = parameterType.getMetaInfo();
                    while (metaInfo == null && parameterType.isArray()) {
                        parameterType = parameterType.getComponentClass();
                        metaInfo = parameterType.getMetaInfo();
                    }
                    if (metaInfo == null) continue;
                    ILocation sourceLocation = paramTypeLocations[i];
                    int start = startPosition + sourceLocation.getStart().getAbsolutePosition(tableHeaderText);
                    int end = startPosition + sourceLocation.getEnd().getAbsolutePosition(tableHeaderText);
                    nodeUsages.add(new SimpleNodeUsage(start, end, metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), NodeType.DATATYPE));
                    if (parameterType.getInstanceClass() != null) continue;
                    this.addTypeError(parameterType, sourceLocation, (IOpenSourceCodeModule)headerSyntaxNode);
                }
            }
            if (CollectionUtils.isNotEmpty(nodeUsages)) {
                cell.setMetaInfo(new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, nodeUsages));
            }
        }
    }

    protected void addTypeError(IOpenClass type, ILocation location, IOpenSourceCodeModule syntaxNode) {
        String message = String.format("Type '%s' was defined with errors", type.getName());
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)location, (IOpenSourceCodeModule)syntaxNode);
        this.getTableSyntaxNode().addError(error);
        BindHelper.processError((SyntaxNodeException)error);
    }

    protected int getSignatureStartIndex() {
        ICell cell = this.getTableSyntaxNode().getGridTable().getCell(0, 0);
        TextInfo tableHeaderText = new TextInfo(cell.getStringValue());
        return this.getTableSyntaxNode().getHeader().getHeaderToken().getLocation().getEnd().getAbsolutePosition(tableHeaderText);
    }
}

