/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import org.openl.rules.lang.xls.load.SimpleWorkbookLoaderFactory;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoaderFactory;
import org.openl.source.IOpenSourceCodeModule;

public abstract class WorkbookLoaders {
    private static final SimpleWorkbookLoaderFactory DEFAULT_FACTORY = new SimpleWorkbookLoaderFactory();
    private static ThreadLocal<WorkbookLoaderFactory> workbookLoaderFactoryHolder = new ThreadLocal<WorkbookLoaderFactory>(){

        @Override
        protected WorkbookLoaderFactory initialValue() {
            return DEFAULT_FACTORY;
        }
    };

    public static void setCurrentFactory(WorkbookLoaderFactory factory) {
        workbookLoaderFactoryHolder.set(factory);
    }

    public static void resetCurrentFactory() {
        workbookLoaderFactoryHolder.remove();
    }

    public static WorkbookLoader getWorkbookLoader(IOpenSourceCodeModule fileSource) {
        return workbookLoaderFactoryHolder.get().createWorkbookLoader(fileSource);
    }
}

