/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.prebind;

import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.conf.IUserContext;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.OpenLSystemProperties;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.IDataBase;
import org.openl.rules.datatype.binding.AliasDatatypeBoundNode;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.lang.xls.XlsBinder;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.prebind.IPrebindHandler;
import org.openl.rules.lang.xls.prebind.XlsLazyModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.property.PropertyTableBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public class XlsPreBinder
extends XlsBinder {
    private IPrebindHandler prebindHandler;

    public XlsPreBinder(IUserContext userContext, IPrebindHandler prebindHandler) {
        super(userContext);
        this.prebindHandler = prebindHandler;
    }

    @Override
    protected void finilizeBind(IMemberBoundNode memberBoundNode, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        if (memberBoundNode instanceof DatatypeTableBoundNode || memberBoundNode instanceof AliasDatatypeBoundNode || memberBoundNode instanceof PropertyTableBoundNode) {
            try {
                memberBoundNode.finalizeBind((IBindingContext)moduleContext);
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tableSyntaxNode, moduleContext);
            }
            catch (CompositeSyntaxNodeException ex) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tableSyntaxNode, moduleContext);
                }
            }
            catch (Throwable t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
                this.processError(error, tableSyntaxNode, moduleContext);
            }
        }
    }

    @Override
    protected XlsLazyModuleOpenClass createModuleOpenClass(XlsModuleSyntaxNode moduleNode, OpenL openl, IDataBase dbase, Set<CompiledDependency> moduleDependencies, IBindingContext bindingContext) {
        return new XlsLazyModuleOpenClass(XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl, dbase, this.prebindHandler, moduleDependencies, Thread.currentThread().getContextClassLoader(), OpenLSystemProperties.isDTDispatchingMode(bindingContext.getExternalParams()), OpenLSystemProperties.isDispatchingValidationEnabled(bindingContext.getExternalParams()));
    }
}

