/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.NaryNode;

public class XlsModuleSyntaxNode
extends NaryNode {
    private OpenlSyntaxNode openlNode;
    private IdentifierNode vocabularyNode;
    private Set<String> imports = new HashSet<String>();
    private Set<String> libraries = new HashSet<String>();

    public XlsModuleSyntaxNode(WorkbookSyntaxNode[] nodes, IOpenSourceCodeModule module, OpenlSyntaxNode openlNode, IdentifierNode vocabularyNode, Collection<String> imports) {
        super(XlsNodeTypes.XLS_MODULE.toString(), null, (ISyntaxNode[])nodes, module);
        this.openlNode = openlNode;
        this.vocabularyNode = vocabularyNode;
        this.imports.addAll(imports);
        this.libraries.addAll(this.libraries);
    }

    public Collection<String> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public void addImport(String value) {
        this.imports.add(value);
    }

    public OpenlSyntaxNode getOpenlNode() {
        return this.openlNode;
    }

    public IdentifierNode getVocabularyNode() {
        return this.vocabularyNode;
    }

    public WorkbookSyntaxNode[] getWorkbookSyntaxNodes() {
        return (WorkbookSyntaxNode[])this.getNodes();
    }

    public TableSyntaxNode[] getXlsTableSyntaxNodes() {
        ArrayList<TableSyntaxNode> tsnodes = new ArrayList<TableSyntaxNode>();
        for (WorkbookSyntaxNode wbsn : this.getWorkbookSyntaxNodes()) {
            for (TableSyntaxNode tableSyntaxNode : wbsn.getTableSyntaxNodes()) {
                tsnodes.add(tableSyntaxNode);
            }
        }
        return tsnodes.toArray(new TableSyntaxNode[tsnodes.size()]);
    }

    public TableSyntaxNode[] getXlsTableSyntaxNodesWithoutErrors() {
        ArrayList<TableSyntaxNode> resultNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode node : this.getXlsTableSyntaxNodes()) {
            if (node.hasErrors()) continue;
            resultNodes.add(node);
        }
        return resultNodes.toArray(new TableSyntaxNode[resultNodes.size()]);
    }
}

