/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodSignature;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeOpenClass
extends ADynamicClass {
    private final Logger log = LoggerFactory.getLogger(DatatypeOpenClass.class);
    private IOpenClass superClass;
    private String packageName;
    private Map<String, IOpenField> fields = null;

    public DatatypeOpenClass(String name, String packageName) {
        super(name, null);
        this.addMethod(new EqualsMethod((IOpenClass)this));
        this.addMethod(new HashCodeMethod((IOpenClass)this));
        this.addMethod(new ToStringMethod((IOpenClass)this));
        this.packageName = packageName;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public IOpenClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(IOpenClass superClass) {
        this.superClass = superClass;
    }

    public Iterable<IOpenClass> superClasses() {
        if (this.superClass != null) {
            return Collections.singletonList(this.superClass);
        }
        return Collections.emptyList();
    }

    public String getPackageName() {
        return this.packageName;
    }

    protected LinkedHashMap<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new LinkedHashMap();
        }
        return (LinkedHashMap)this.fieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IOpenField> getFields() {
        if (this.fields == null) {
            DatatypeOpenClass datatypeOpenClass = this;
            synchronized (datatypeOpenClass) {
                if (this.fields == null) {
                    this.fields = new LinkedHashMap<String, IOpenField>();
                    Iterable<IOpenClass> superClasses = this.superClasses();
                    for (IOpenClass superClass : superClasses) {
                        this.fields.putAll(superClass.getFields());
                    }
                    this.fields.putAll(this.fieldMap());
                }
            }
        }
        return Collections.unmodifiableMap(this.fields);
    }

    public Map<String, IOpenField> getDeclaredFields() {
        return (Map)((HashMap)this.fieldMap()).clone();
    }

    public Object newInstance(IRuntimeEnv env) {
        Object instance = null;
        try {
            instance = this.getInstanceClass().newInstance();
        }
        catch (InstantiationException e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        catch (Throwable e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        return instance;
    }

    public IOpenClass getComponentClass() {
        if (this.isArray()) {
            return JavaOpenClass.getOpenClass(this.getInstanceClass().getComponentType());
        }
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.superClass).append((Object)this.getMetaInfo()).append((Object)this.packageName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DatatypeOpenClass other = (DatatypeOpenClass)((Object)obj);
        return new EqualsBuilder().append((Object)this.superClass, (Object)other.getSuperClass()).append((Object)this.getMetaInfo(), (Object)other.getMetaInfo()).append((Object)this.packageName, (Object)other.getPackageName()).isEquals();
    }

    public static class HashCodeMethod
    implements IOpenMethod {
        private IOpenClass openClass;

        public HashCodeMethod(IOpenClass forClass) {
            this.openClass = forClass;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getType() {
            return JavaOpenClass.INT;
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName(int mode) {
            return this.getName();
        }

        public String getName() {
            return "hashCode";
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            int result = 0;
            Map fields = this.openClass.getFields();
            for (IOpenField field : fields.values()) {
                result = 31 * result + (field != null ? field.hashCode() : 0);
            }
            return result;
        }
    }

    public static class EqualsMethod
    implements IOpenMethod {
        private IOpenClass openClass;

        public EqualsMethod(IOpenClass forClass) {
            this.openClass = forClass;
        }

        public IMethodSignature getSignature() {
            return new MethodSignature(new IOpenClass[]{JavaOpenClass.OBJECT});
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getType() {
            return JavaOpenClass.BOOLEAN;
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName(int mode) {
            return this.getName();
        }

        public String getName() {
            return "equals";
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            EqualsBuilder builder = new EqualsBuilder();
            Map fields = this.openClass.getFields();
            for (IOpenField field : fields.values()) {
                builder.append(field.get(target, env), field.get(params[0], env));
            }
            return builder.isEquals();
        }
    }

    public static class ToStringMethod
    implements IOpenMethod {
        private IOpenClass openClass;

        public ToStringMethod(IOpenClass forClass) {
            this.openClass = forClass;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getType() {
            return JavaOpenClass.STRING;
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName(int mode) {
            return this.getName();
        }

        public String getName() {
            return "toString";
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            StringBuilder builder = new StringBuilder(this.openClass.getDisplayName(0) + "{ ");
            Map fields = this.openClass.getFields();
            for (Map.Entry field : fields.entrySet()) {
                builder.append((String)field.getKey()).append("=").append(((IOpenField)field.getValue()).get(target, env)).append(" ");
            }
            builder.append('}');
            return builder.toString();
        }
    }

    public static class OpenFieldsConstructor
    implements IOpenMethod {
        private IOpenClass openClass;

        public OpenFieldsConstructor(IOpenClass openClass) {
            this.openClass = openClass;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public String getDisplayName(int mode) {
            return this.openClass.getDisplayName(mode);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return this.openClass.getName();
        }

        public IMethodSignature getSignature() {
            Map fields = this.openClass.getFields();
            IOpenClass[] params = new IOpenClass[fields.size()];
            String[] names = new String[fields.size()];
            int i = 0;
            for (Map.Entry field : fields.entrySet()) {
                params[i] = ((IOpenField)field.getValue()).getType();
                names[i] = (String)field.getKey();
                ++i;
            }
            return new MethodSignature(params, names);
        }

        public IOpenClass getType() {
            return this.openClass;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            Object result = this.openClass.newInstance(env);
            int i = 0;
            for (IOpenField field : this.openClass.getFields().values()) {
                field.set(result, params[i], env);
                ++i;
            }
            return result;
        }

        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return this.openClass.getName();
        }
    }
}

