/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.property;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.property.PropertyTableBoundNode;
import org.openl.rules.property.exception.DuplicatedPropertiesTableException;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class PropertyTableBinder
extends DataNodeBinder {
    private static final String DEFAULT_TABLE_NAME_PREFIX = "InheritedProperties: ";
    private static final String SCOPE_PROPERTY_NAME = "scope";

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tsn, OpenL openl, IBindingContext cxt, XlsModuleOpenClass module) throws Exception {
        assert (cxt instanceof RulesModuleBindingContext);
        PropertyTableBoundNode propertyNode = (PropertyTableBoundNode)this.makeNode(tsn, module);
        String tableName = this.parseHeader(tsn);
        propertyNode.setTableName(tableName);
        if (tableName == null) {
            tableName = DEFAULT_TABLE_NAME_PREFIX + tsn.getUri();
        }
        ITable propertyTable = module.getDataBase().registerTable(tableName, tsn);
        JavaOpenClass propertiesClass = JavaOpenClass.getOpenClass(TableProperties.class);
        ILogicalTable propTableBody = this.getTableBody(tsn);
        try {
            this.processTable(module, propertyTable, propTableBody, tableName, (IOpenClass)propertiesClass, cxt, openl, false);
        }
        catch (SyntaxNodeException ex) {
            throw SyntaxNodeExceptionUtils.createError((String)"Table wasn't defined properly", (Throwable)ex, (ISyntaxNode)ex.getSyntaxNode());
        }
        TableProperties propertiesInstance = ((TableProperties[])propertyTable.getDataArray())[0];
        propertiesInstance.setPropertiesSection(tsn.getTable());
        propertiesInstance.setCurrentTableType(tsn.getType());
        PropertiesChecker.checkProperties(propertiesInstance.getAllProperties().keySet(), tsn, InheritanceLevel.getEnumByValue(propertiesInstance.getPropertyValueAsString(SCOPE_PROPERTY_NAME)));
        tsn.setTableProperties(propertiesInstance);
        this.analysePropertiesNode(tsn, propertiesInstance, (RulesModuleBindingContext)cxt, propertyNode);
        propertyNode.setPropertiesInstance(propertiesInstance);
        return propertyNode;
    }

    private String parseHeader(TableSyntaxNode tsn) throws Exception {
        IOpenSourceCodeModule src = tsn.getHeader().getModule();
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
        if (parsedHeader.length > 1) {
            return parsedHeader[1].getIdentifier();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void analysePropertiesNode(TableSyntaxNode tableSyntaxNode, TableProperties propertiesInstance, RulesModuleBindingContext bindingContext, PropertyTableBoundNode propertyNode) throws SyntaxNodeException {
        String scope = propertiesInstance.getScope();
        if (scope == null) {
            String message = String.format("There is no obligatory property '%s'", SCOPE_PROPERTY_NAME);
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
        }
        if (this.isModuleProperties(scope)) {
            this.processModuleProperties(tableSyntaxNode, propertiesInstance, bindingContext, propertyNode);
            return;
        }
        if (this.isCategoryProperties(scope)) {
            this.processCategoryProperties(tableSyntaxNode, propertiesInstance, bindingContext, propertyNode);
            return;
        }
        String message = String.format("Value of the property '%s' is neither '%s' or '%s'", SCOPE_PROPERTY_NAME, InheritanceLevel.MODULE.getDisplayName(), InheritanceLevel.CATEGORY.getDisplayName());
        throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
    }

    private void processCategoryProperties(TableSyntaxNode tableSyntaxNode, TableProperties propertiesInstance, RulesModuleBindingContext bindingContext, PropertyTableBoundNode propertyNode) throws SyntaxNodeException {
        String category = this.getCategoryToApplyProperties(tableSyntaxNode, propertiesInstance);
        String key = RulesModuleBindingContext.CATEGORY_PROPERTIES_KEY + category;
        InheritanceLevel currentLevel = InheritanceLevel.CATEGORY;
        this.checkPropertiesLevel(currentLevel, propertiesInstance, tableSyntaxNode, (IBindingContext)bindingContext);
        if (bindingContext.isTableSyntaxNodeExist(key)) {
            String message = String.format("Properties for category '%s' already exists", category);
            throw new DuplicatedPropertiesTableException(message, null, (ISyntaxNode)tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private void checkPropertiesLevel(InheritanceLevel currentLevel, TableProperties propertiesInstance, TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) throws SyntaxNodeException {
        for (String propertyNameToCheck : propertiesInstance.getAllProperties().keySet()) {
            if (PropertiesChecker.isPropertySuitableForLevel(currentLevel, propertyNameToCheck)) continue;
            String message = String.format("Property '%s' can`t be defined on the '%s' level", propertyNameToCheck, currentLevel.getDisplayName());
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
        }
    }

    private void processModuleProperties(TableSyntaxNode tableSyntaxNode, TableProperties propertiesInstance, RulesModuleBindingContext bindingContext, PropertyTableBoundNode propertyNode) throws SyntaxNodeException {
        String key = RulesModuleBindingContext.MODULE_PROPERTIES_KEY;
        InheritanceLevel currentLevel = InheritanceLevel.MODULE;
        this.checkPropertiesLevel(currentLevel, propertiesInstance, tableSyntaxNode, (IBindingContext)bindingContext);
        if (bindingContext.isTableSyntaxNodeExist(key)) {
            XlsWorkbookSourceCodeModule module = ((XlsSheetSourceCodeModule)tableSyntaxNode.getModule()).getWorkbookSource();
            String moduleName = module.getDisplayName();
            String message = String.format("Properties for module '%s' already exists", moduleName);
            throw new DuplicatedPropertiesTableException(message, null, (ISyntaxNode)tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private String getCategoryToApplyProperties(TableSyntaxNode tsn, TableProperties properties) {
        String category = properties.getCategory();
        if (category != null) {
            return category;
        }
        return ((XlsSheetSourceCodeModule)tsn.getModule()).getSheetName();
    }

    private boolean isModuleProperties(String scope) {
        return InheritanceLevel.MODULE.getDisplayName().equals(scope);
    }

    private boolean isCategoryProperties(String scope) {
        return InheritanceLevel.CATEGORY.getDisplayName().equals(scope);
    }

    @Override
    protected ATableBoundNode makeNode(TableSyntaxNode tsn, XlsModuleOpenClass module) {
        return new PropertyTableBoundNode(tsn, module);
    }
}

