/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.GridSplitter;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.util.StringTool;

public abstract class AGrid
implements IGrid {
    public static final String RANGE_SEPARATOR = ":";

    @Override
    public IGridTable[] getTables() {
        return new GridSplitter(this).split();
    }

    @Override
    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        if (colStart == colEnd && rowStart == rowEnd) {
            return this.getUri() + "&" + "cell=" + this.getCell(colStart, rowStart).getUri();
        }
        String range = this.getCell(colStart, rowStart).getUri() + RANGE_SEPARATOR + this.getCell(colEnd, rowEnd).getUri();
        return this.getUri() + "&" + "range" + "=" + StringTool.encodeURL((String)range);
    }

    @Override
    public IGridRegion getRegionContaining(int col, int row) {
        int nregions = this.getNumberOfMergedRegions();
        for (int i = 0; i < nregions; ++i) {
            IGridRegion reg = this.getMergedRegion(i);
            if (!IGridRegion.Tool.contains(reg, col, row)) continue;
            return reg;
        }
        return null;
    }

    @Override
    public IGridRegion getRegionStartingAt(int colFrom, int rowFrom) {
        IGridRegion reg = this.getRegionContaining(colFrom, rowFrom);
        if (reg != null && reg.getLeft() == colFrom && reg.getTop() == rowFrom) {
            return reg;
        }
        return null;
    }

    @Override
    public boolean isPartOfTheMergedRegion(int x, int y) {
        return this.getRegionContaining(x, y) != null;
    }

    @Override
    public boolean isTopLeftCellInMergedRegion(int column, int row) {
        return this.getRegionStartingAt(column, row) != null;
    }

    @Override
    public boolean isInOneMergedRegion(int firstCellColumn, int firstCellRow, int secondCellColumn, int secondCellRow) {
        IGridRegion region = this.getRegionContaining(firstCellColumn, firstCellRow);
        return region != null && IGridRegion.Tool.contains(region, secondCellColumn, secondCellRow);
    }
}

