/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.ui.ICellStyle;

public abstract class AUndoableCellAction
implements IUndoableGridTableAction {
    private int col;
    private int row;
    private Object prevValue;
    private String prevFormula;
    private ICellStyle prevStyle;
    private ICellComment prevComment;

    public AUndoableCellAction(int col, int row) {
        this.col = col;
        this.row = row;
    }

    protected void savePrevCell(IWritableGrid grid) {
        ICell cell = grid.getCell(this.col, this.row);
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        this.setPrevStyle(cell.getStyle());
        this.setPrevComment(cell.getComment());
    }

    protected void restorePrevCell(IWritableGrid grid) {
        if (this.prevValue != null || this.prevStyle != null) {
            grid.createCell(this.col, this.row, this.prevValue, this.prevFormula, this.prevStyle, this.prevComment);
        } else {
            grid.clearCell(this.col, this.row);
        }
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public Object getPrevValue() {
        return this.prevValue;
    }

    public void setPrevValue(Object prevValue) {
        this.prevValue = prevValue;
    }

    public String getPrevFormula() {
        return this.prevFormula;
    }

    public void setPrevFormula(String prevFormula) {
        this.prevFormula = prevFormula;
    }

    public ICellStyle getPrevStyle() {
        return this.prevStyle;
    }

    public void setPrevStyle(ICellStyle prevStyle) {
        this.prevStyle = prevStyle;
    }

    public ICellComment getPrevComment() {
        return this.prevComment;
    }

    public void setPrevComment(ICellComment prevComment) {
        this.prevComment = prevComment;
    }
}

