/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.service.TableServiceException;
import org.openl.rules.service.TableServiceImpl;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.UndoableEditTableAction;

public class UndoableMoveTableAction
extends UndoableEditTableAction {
    private IGridRegion prevRegion = null;
    private IGridRegion newRegion = null;

    public IGridRegion getNewRegion() {
        return this.newRegion;
    }

    @Override
    public void doAction(IGridTable table) {
        IGridTable fullTable = UndoableMoveTableAction.getOriginalTable(table);
        this.prevRegion = fullTable.getRegion();
        TableServiceImpl tableService = new TableServiceImpl();
        try {
            if (this.newRegion == null) {
                this.newRegion = tableService.moveTable(fullTable);
            } else {
                tableService.moveTableTo(fullTable, this.newRegion);
            }
        }
        catch (TableServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void undoAction(IGridTable table) {
        if (this.newRegion != null) {
            try {
                new TableServiceImpl().moveTableTo(new GridTable(this.newRegion, table.getGrid()), this.prevRegion);
            }
            catch (TableServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

