/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions.style;

import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.ui.ICellStyle;

public class SetAlignmentAction
extends AUndoableCellAction {
    private int prevAlignment;
    private int newAlignment;

    public SetAlignmentAction(int col, int row, int alignment) {
        super(col, row);
        this.newAlignment = alignment;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICellStyle style = grid.getCell(this.getCol(), this.getRow()).getStyle();
        this.prevAlignment = style != null ? style.getHorizontalAlignment() : 0;
        grid.setCellAlignment(this.getCol(), this.getRow(), this.newAlignment);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        grid.setCellAlignment(this.getCol(), this.getRow(), this.prevAlignment);
    }
}

