/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.formatters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.openl.util.ArrayTool;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;
import org.openl.util.formatters.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayFormatter
implements IFormatter {
    private final Logger log = LoggerFactory.getLogger(ArrayFormatter.class);
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    private IFormatter elementFormat;

    public ArrayFormatter(IFormatter elementFormat) {
        this.elementFormat = elementFormat;
    }

    public String format(Object value) {
        String result = null;
        if (value != null) {
            if (!value.getClass().isArray()) {
                this.log.debug("Should be an array: {}", value);
                return result;
            }
            Object[] array = ArrayTool.toArray((Object)value);
            Object[] elementResults = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                elementResults[i] = this.elementFormat.format(element);
                result = StringUtils.join((Object[])elementResults, (String)ARRAY_ELEMENTS_SEPARATOR);
            }
        }
        return result;
    }

    public Object parse(String value) {
        Object[] result = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] elementValues = StringTool.splitAndEscape((String)value, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
            ArrayList<Object> elements = new ArrayList<Object>();
            Class<Object> elementType = null;
            for (String elementValue : elementValues) {
                Object element = this.elementFormat.parse(elementValue);
                elements.add(element);
                Class<?> type = element.getClass();
                if (elementType == null) {
                    elementType = type;
                    continue;
                }
                if (elementType == type) continue;
                elementType = Object.class;
            }
            if (elementType == null) {
                return null;
            }
            Object[] resultArray = (Object[])Array.newInstance(elementType, elements.size());
            result = elements.toArray(resultArray);
        }
        return result;
    }
}

