/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.lang.reflect.Array;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodKey;

public final class DimensionPropertiesMethodKey {
    private final IOpenMethod method;

    public DimensionPropertiesMethodKey(IOpenMethod method) {
        this.method = method;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DimensionPropertiesMethodKey)) {
            return false;
        }
        DimensionPropertiesMethodKey key = (DimensionPropertiesMethodKey)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)new MethodKey(this.method), (Object)new MethodKey(key.getMethod()));
        String[] dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
        for (int i = 0; i < dimensionalPropertyNames.length; ++i) {
            Object propertyValue1 = PropertiesHelper.getMethodProperties(this.method).get(dimensionalPropertyNames[i]);
            Object propertyValue2 = PropertiesHelper.getMethodProperties(key.getMethod()).get(dimensionalPropertyNames[i]);
            if (this.isEmpty(propertyValue1) && this.isEmpty(propertyValue2)) continue;
            equalsBuilder.append(propertyValue1, propertyValue2);
        }
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        String[] dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
        Map<String, Object> methodProperties = PropertiesHelper.getMethodProperties(this.method);
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)new MethodKey(this.method));
        if (methodProperties != null) {
            for (String dimensionalPropertyName : dimensionalPropertyNames) {
                Object property = methodProperties.get(dimensionalPropertyName);
                hashCodeBuilder.append(property);
            }
        }
        return hashCodeBuilder.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new MethodKey(this.method));
        String[] dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
        stringBuilder.append('[');
        if (PropertiesHelper.getMethodProperties(this.method) != null) {
            for (int i = 0; i < dimensionalPropertyNames.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(dimensionalPropertyNames[i]).append('=');
                stringBuilder.append(PropertiesHelper.getTableProperties(this.method).getPropertyValueAsString(dimensionalPropertyNames[i]));
            }
        }
        return stringBuilder.append(']').toString();
    }

    private boolean isEmpty(Object propertyValue) {
        if (propertyValue == null) {
            return true;
        }
        if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            if (length == 0) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                if (Array.get(propertyValue, i) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

