/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.expressions.match;

import org.openl.rules.table.properties.expressions.match.IMatchingExpression;
import org.openl.util.StringUtils;

public abstract class AMatchingExpression
implements IMatchingExpression {
    private String contextAttribute;
    private String operation;
    private String operationName;
    private IMatchingExpression contextAttributeExpression;

    @Override
    public IMatchingExpression getContextAttributeExpression() {
        return this.contextAttributeExpression;
    }

    @Override
    public abstract boolean isContextAttributeExpression();

    public AMatchingExpression(String operationName, IMatchingExpression matchingExpression) {
        this.operationName = operationName;
        if (matchingExpression == null) {
            throw new IllegalArgumentException("Parameter 'contextAttributeExpression' can not be null");
        }
        this.contextAttributeExpression = matchingExpression;
    }

    public AMatchingExpression(String operationName, String operation, String contextAttribute) {
        this.operationName = operationName;
        this.operation = operation;
        if (contextAttribute == null) {
            throw new IllegalArgumentException("Parameter 'contextAttribute' can not be null");
        }
        this.contextAttribute = contextAttribute;
    }

    public AMatchingExpression(String contextAttribute) {
        if (contextAttribute == null) {
            throw new IllegalArgumentException("Parameter 'contextAttribute' can not be null");
        }
        this.contextAttribute = contextAttribute;
    }

    @Override
    public String getCodeExpression(String param) {
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            return new StringBuilder(64).append(param).append(' ').append(this.getOperation()).append(' ').append(this.contextAttribute).toString();
        }
        return null;
    }

    @Override
    public String getContextAttribute() {
        if (!this.isContextAttributeExpression()) {
            return this.contextAttribute;
        }
        return this.getContextAttributeExpression().getContextAttribute();
    }

    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }
}

