/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.load.CellLoader;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.IncorrectFormulaException;
import org.openl.rules.table.xls.XlsCellComment;
import org.openl.rules.table.xls.XlsCellFont;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.XlsUtil;
import org.openl.rules.table.xls.formatters.XlsDataFormatterFactory;
import org.openl.rules.table.xls.writers.AXlsCellWriter;
import org.openl.util.NumberUtils;
import org.openl.util.StringPool;
import org.openl.util.formatters.IFormatter;

public class XlsCell
implements ICell {
    private int column;
    private int row;
    private IGridRegion region;
    private CellLoader cellLoader;
    private int width = 1;
    private int height = 1;
    private XlsSheetGridModel gridModel;

    public XlsCell(int column, int row, XlsSheetGridModel gridModel) {
        this.column = column;
        this.row = row;
        this.region = gridModel.getRegionContaining(column, row);
        this.cellLoader = gridModel.getSheetSource().getSheetLoader().getCellLoader(column, row);
        if (this.region != null && this.region.getLeft() == column && this.region.getTop() == row) {
            this.width = this.region.getRight() - this.region.getLeft() + 1;
            this.height = this.region.getBottom() - this.region.getTop() + 1;
        }
        this.gridModel = gridModel;
    }

    @Override
    public ICellStyle getStyle() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        return this.getCellStyle(cell);
    }

    @Override
    public int getAbsoluteColumn() {
        return this.getColumn();
    }

    @Override
    public int getAbsoluteRow() {
        return this.getRow();
    }

    @Override
    public IGridRegion getAbsoluteRegion() {
        IGridRegion absoluteRegion = this.getRegion();
        if (absoluteRegion == null) {
            absoluteRegion = new GridRegion(this.row, this.column, this.row, this.column);
        }
        return absoluteRegion;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public ICellFont getFont() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        Font font = this.gridModel.getSheetSource().getSheet().getWorkbook().getFontAt(cell.getCellStyle().getFontIndex());
        return new XlsCellFont(font, this.gridModel.getSheetSource().getSheet().getWorkbook());
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public IGridRegion getRegion() {
        return this.region;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public Object getObjectValue() {
        if (this.region == null) {
            return this.extractCellValue();
        }
        return this.extractValueFromRegion();
    }

    public void setObjectValue(Object value) {
        Cell cell = this.getCell();
        if (value != null) {
            boolean writeCellMetaInfo = true;
            if (this.gridModel.hasEnumDomainMetaInfo(this.column, this.row)) {
                writeCellMetaInfo = false;
            }
            if (this.gridModel.hasRangeDomainMetaInfo(this.column, this.row)) {
                writeCellMetaInfo = false;
            }
            AXlsCellWriter cellWriter = this.gridModel.getCellWriter(value);
            cellWriter.setCellToWrite(cell);
            cellWriter.setValueToWrite(value);
            cellWriter.writeCellValue(writeCellMetaInfo);
        } else {
            cell.setCellType(3);
        }
    }

    @Override
    public String getStringValue() {
        Object res = null;
        try {
            res = this.getObjectValue();
        }
        catch (IncorrectFormulaException incorrectFormulaException) {
            // empty catch block
        }
        return res == null ? null : String.valueOf(res);
    }

    public void setStringValue(String value) {
        this.getCell().setCellValue(value);
    }

    @Override
    public String getFormattedValue() {
        IFormatter cellDataFormatter;
        String formattedValue = null;
        Object value = this.getObjectValue();
        if (value != null && (cellDataFormatter = this.getDataFormatter()) != null) {
            formattedValue = cellDataFormatter.format(value);
        }
        if (formattedValue == null && (formattedValue = this.getStringValue()) == null) {
            formattedValue = "";
        }
        return formattedValue;
    }

    @Override
    public IFormatter getDataFormatter() {
        return XlsDataFormatterFactory.getFormatter(this);
    }

    @Override
    public ICell getTopLeftCellFromRegion() {
        int row = this.region.getTop();
        int col = this.region.getLeft();
        return this.gridModel.getCell(col, row);
    }

    private boolean isCurrentCellATopLeftCellInRegion() {
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        boolean isTopLeft = topLeftCell.getColumn() == this.column && topLeftCell.getRow() == this.row;
        return isTopLeft;
    }

    private Object extractValueFromRegion() {
        if (this.isCurrentCellATopLeftCellInRegion()) {
            return this.extractCellValue();
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getObjectValue();
    }

    private Object extractCellValue() {
        Cell cell = this.getCell();
        if (cell != null) {
            int type = cell.getCellType();
            if (type == 2) {
                type = cell.getCachedFormulaResultType();
            }
            switch (type) {
                case 3: {
                    return null;
                }
                case 4: {
                    return cell.getBooleanCellValue();
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return cell.getDateCellValue();
                    }
                    double value = cell.getNumericCellValue();
                    return NumberUtils.intOrDouble((double)value);
                }
                case 1: {
                    String str = cell.getStringCellValue();
                    return StringPool.intern((String)str);
                }
            }
            return "unknown type: " + cell.getCellType();
        }
        return null;
    }

    @Override
    public String getFormula() {
        if (this.getCell() == null && this.region == null) {
            return null;
        }
        if (this.region != null) {
            return this.getFormulaFromRegion();
        }
        return this.cellFormula();
    }

    private String getFormulaFromRegion() {
        if (this.isCurrentCellATopLeftCellInRegion()) {
            return this.cellFormula();
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getType() == 2 ? topLeftCell.getFormula() : null;
    }

    private String cellFormula() {
        Cell cell = this.getCell();
        return cell.getCellType() == 2 ? cell.getCellFormula() : null;
    }

    @Override
    public int getType() {
        Cell cell = this.getCell();
        if (cell == null && this.region == null) {
            return 3;
        }
        if (this.region != null) {
            return this.getTypeFromRegion();
        }
        return cell.getCellType();
    }

    private int getTypeFromRegion() {
        if (this.isCurrentCellATopLeftCellInRegion()) {
            return this.getCell().getCellType();
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getType();
    }

    @Override
    public String getUri() {
        return XlsUtil.xlsCellPresentation(this.column, this.row);
    }

    @Override
    public boolean getNativeBoolean() {
        return true;
    }

    @Override
    public double getNativeNumber() {
        Cell cell = this.getCell();
        if (cell == null) {
            return 0.0;
        }
        return cell.getNumericCellValue();
    }

    @Override
    public int getNativeType() {
        Cell cell = this.getCell();
        if (cell == null) {
            return 3;
        }
        int type = cell.getCellType();
        if (type == 2) {
            return cell.getCachedFormulaResultType();
        }
        return type;
    }

    @Override
    public boolean hasNativeType() {
        return true;
    }

    @Override
    public Date getNativeDate() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        try {
            return cell.getDateCellValue();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Cannot parse the value as a date : " + cell.getNumericCellValue());
        }
    }

    @Override
    public CellMetaInfo getMetaInfo() {
        return this.gridModel.getCellMetaInfo(this.column, this.row);
    }

    @Override
    public void setMetaInfo(CellMetaInfo metaInfo) {
        this.gridModel.setCellMetaInfo(this.column, this.row, metaInfo);
    }

    private ICellStyle getCellStyle(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style != null) {
            Workbook workbook = this.gridModel.getSheetSource().getSheet().getWorkbook();
            return new XlsCellStyle(style, workbook);
        }
        return null;
    }

    @Override
    public ICellComment getComment() {
        Cell cell = this.getCell();
        if (cell != null) {
            Comment comment = cell.getCellComment();
            if (comment != null) {
                return new XlsCellComment(comment);
            }
            if (this.region != null && !this.isCurrentCellATopLeftCellInRegion()) {
                ICell topLeftCell = this.getTopLeftCellFromRegion();
                return topLeftCell.getComment();
            }
        }
        return null;
    }

    public Cell getXlsCell() {
        return this.getCell();
    }

    private Cell getCell() {
        return this.cellLoader.getCell();
    }
}

