/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.PoiExcelHelper;

public class XlsCellStyle
implements ICellStyle {
    private CellStyle xlsStyle;
    private Workbook workbook;

    public XlsCellStyle(CellStyle xlsStyle, Workbook workbook) {
        this.xlsStyle = xlsStyle;
        this.workbook = workbook;
    }

    @Override
    public short[][] getBorderRGB() {
        return PoiExcelHelper.getCellBorderColors(this.xlsStyle, this.workbook);
    }

    @Override
    public short[] getBorderStyle() {
        return PoiExcelHelper.getCellBorderStyles(this.xlsStyle);
    }

    @Override
    public short getFillPattern() {
        return this.xlsStyle.getFillPattern();
    }

    public boolean hasNoFill() {
        return this.getFillPattern() == 0;
    }

    @Override
    public short[] getFillBackgroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        return PoiExcelHelper.toRgb(this.xlsStyle.getFillBackgroundColorColor());
    }

    @Override
    public short getFillBackgroundColorIndex() {
        return this.xlsStyle.getFillBackgroundColor();
    }

    @Override
    public short[] getFillForegroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        return PoiExcelHelper.toRgb(this.xlsStyle.getFillForegroundColorColor());
    }

    @Override
    public short getFillForegroundColorIndex() {
        return this.xlsStyle.getFillForegroundColor();
    }

    @Override
    public int getHorizontalAlignment() {
        return this.xlsStyle == null ? 0 : (int)this.xlsStyle.getAlignment();
    }

    @Override
    public int getVerticalAlignment() {
        return this.xlsStyle == null ? 0 : (int)this.xlsStyle.getVerticalAlignment();
    }

    @Override
    public int getIdent() {
        return this.xlsStyle.getIndention();
    }

    @Override
    public int getRotation() {
        return this.xlsStyle.getRotation();
    }

    @Override
    public boolean isWrappedText() {
        return this.xlsStyle.getWrapText();
    }

    public CellStyle getXlsStyle() {
        return this.xlsStyle;
    }
}

