/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.AGrid;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.Point;
import org.openl.rules.table.RegionsPool;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.rules.table.xls.XlsCell;
import org.openl.rules.table.xls.XlsCellComment;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsGridRegion;
import org.openl.rules.table.xls.writers.AXlsCellWriter;
import org.openl.rules.table.xls.writers.XlsCellArrayWriter;
import org.openl.rules.table.xls.writers.XlsCellBooleanWriter;
import org.openl.rules.table.xls.writers.XlsCellDateWriter;
import org.openl.rules.table.xls.writers.XlsCellEnumArrayWriter;
import org.openl.rules.table.xls.writers.XlsCellEnumWriter;
import org.openl.rules.table.xls.writers.XlsCellFormulaWriter;
import org.openl.rules.table.xls.writers.XlsCellNumberWriter;
import org.openl.rules.table.xls.writers.XlsCellStringWriter;
import org.openl.types.IOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.EnumUtils;
import org.openl.util.StringUtils;

public class XlsSheetGridModel
extends AGrid
implements IWritableGrid {
    private XlsSheetSourceCodeModule sheetSource;
    private RegionsPool mergedRegionsPool;
    private Map<CellKey, CellMetaInfo> metaInfoMap = new HashMap<CellKey, CellMetaInfo>();
    private Map<String, AXlsCellWriter> cellWriters = new HashMap<String, AXlsCellWriter>();

    public XlsSheetGridModel(XlsSheetSourceCodeModule sheetSource) {
        this.sheetSource = sheetSource;
    }

    private void extractMergedRegions() {
        this.mergedRegionsPool = new RegionsPool(null);
        int nregions = this.getNumberOfMergedRegions();
        Sheet sheet = this.getSheet();
        for (int i = 0; i < nregions; ++i) {
            CellRangeAddress reg = PoiExcelHelper.getMergedRegionAt(i, sheet);
            this.mergedRegionsPool.add(new XlsGridRegion(reg));
        }
    }

    private void initCellWriters() {
        this.cellWriters.put("Array Writer", new XlsCellArrayWriter(this));
        this.cellWriters.put("Boolean Writer", new XlsCellBooleanWriter(this));
        this.cellWriters.put("Date Writer", new XlsCellDateWriter(this));
        this.cellWriters.put("Enum Array Writer", new XlsCellEnumArrayWriter(this));
        this.cellWriters.put("Enum Writer", new XlsCellEnumWriter(this));
        this.cellWriters.put("Formula Writer", new XlsCellFormulaWriter(this));
        this.cellWriters.put("Number Writer", new XlsCellNumberWriter(this));
        this.cellWriters.put("String Writer", new XlsCellStringWriter(this));
    }

    @Override
    public int addMergedRegion(IGridRegion reg) {
        Object topLeftCellValue = this.findFirstValueInRegion(reg);
        for (int row = reg.getTop(); row <= reg.getBottom(); ++row) {
            for (int column = reg.getLeft(); column <= reg.getRight(); ++column) {
                if (column == reg.getLeft() && row == reg.getTop()) continue;
                this.clearCellValue(column, row);
            }
        }
        this.setCellValue(reg.getLeft(), reg.getTop(), topLeftCellValue);
        this.getMergedRegionsPool().add(reg);
        return this.getSheet().addMergedRegion(new CellRangeAddress(reg.getTop(), reg.getBottom(), reg.getLeft(), reg.getRight()));
    }

    private RegionsPool getMergedRegionsPool() {
        if (this.mergedRegionsPool == null) {
            this.extractMergedRegions();
        }
        return this.mergedRegionsPool;
    }

    private Object findFirstValueInRegion(IGridRegion reg) {
        for (int row = reg.getTop(); row <= reg.getBottom(); ++row) {
            for (int column = reg.getLeft(); column <= reg.getRight(); ++column) {
                Object cellValue = this.getCell(column, row).getObjectValue();
                if (cellValue == null) continue;
                return cellValue;
            }
        }
        return null;
    }

    public void clearCellValue(int col, int row) {
        this.setCellValue(col, row, null);
    }

    @Override
    public void clearCell(int col, int row) {
        Sheet sheet = this.getSheet();
        this.setCellMetaInfo(col, row, null);
        Cell cell = PoiExcelHelper.getCell(col, row, sheet);
        if (cell != null) {
            cell.removeCellComment();
            cell.removeHyperlink();
            sheet.getRow(row).removeCell(cell);
        }
    }

    @Override
    public void copyCell(int colFrom, int rowFrom, int colTo, int rowTo) {
        Cell cellFrom = PoiExcelHelper.getCell(colFrom, rowFrom, this.getSheet());
        this.copyCell(cellFrom, colTo, rowTo, this.getCellMetaInfo(colFrom, rowFrom));
    }

    @Override
    public void createCell(int col, int row, Object value, String formula, ICellStyle style, ICellComment comment) {
        if (StringUtils.isNotBlank((CharSequence)formula)) {
            this.setCellFormula(col, row, formula);
        } else {
            this.setCellValue(col, row, value);
        }
        this.setCellStyle(col, row, style);
        this.setCellMetaInfo(col, row, this.getCellMetaInfo(col, row));
        this.setCellComment(col, row, comment);
    }

    protected void copyCell(Cell cellFrom, int colTo, int rowTo, CellMetaInfo meta) {
        Sheet sheet = this.getSheet();
        Cell cellTo = PoiExcelHelper.getCell(colTo, rowTo, sheet);
        if (cellFrom == null) {
            if (cellTo != null) {
                this.clearCell(colTo, rowTo);
            }
            return;
        }
        if (cellTo == null) {
            cellTo = PoiExcelHelper.getOrCreateCell(colTo, rowTo, sheet);
        }
        PoiExcelHelper.copyCellValue(cellFrom, cellTo);
        PoiExcelHelper.copyCellStyle(cellFrom, cellTo, sheet);
        cellTo.removeCellComment();
        this.setCellMetaInfo(colTo, rowTo, meta);
    }

    @Override
    public IGridRegion findEmptyRect(int width, int height) {
        int lastRow = PoiExcelHelper.getLastRowNum(this.getSheet());
        int top = lastRow + 2;
        int left = 1;
        return new GridRegion(top, left, top + height - 1, left + width - 1);
    }

    @Override
    public ICell getCell(int column, int row) {
        return new XlsCell(column, row, this);
    }

    protected CellMetaInfo getCellMetaInfo(int col, int row) {
        CellKey ck = CellKey.CellKeyFactory.getCellKey(col, row);
        return this.metaInfoMap.get(ck);
    }

    @Override
    public int getColumnWidth(int col) {
        return PoiExcelHelper.getColumnWidth(col, this.getSheet());
    }

    @Override
    public int getMaxColumnIndex(int rownum) {
        return PoiExcelHelper.getMaxColumnIndex(rownum, this.getSheet());
    }

    @Override
    public int getMaxRowIndex() {
        return PoiExcelHelper.getMaxRowIndex(this.getSheet());
    }

    @Override
    public synchronized IGridRegion getMergedRegion(int i) {
        return new XlsGridRegion(PoiExcelHelper.getMergedRegionAt(i, this.getSheet()));
    }

    @Override
    public int getMinColumnIndex(int rownum) {
        return PoiExcelHelper.getMinColumnIndex(rownum, this.getSheet());
    }

    @Override
    public int getMinRowIndex() {
        return PoiExcelHelper.getMinRowIndex(this.getSheet());
    }

    public String getName() {
        return this.sheetSource.getSheetName();
    }

    @Override
    public int getNumberOfMergedRegions() {
        return PoiExcelHelper.getNumberOfMergedRegions(this.getSheet());
    }

    public String getRangeUri(IGridRegion region) {
        return this.getRangeUri(region.getLeft(), region.getTop(), region.getRight(), region.getBottom());
    }

    @Override
    public IGridRegion getRegionContaining(int x, int y) {
        return this.getMergedRegionsPool().getRegionContaining(x, y);
    }

    public XlsSheetSourceCodeModule getSheetSource() {
        return this.sheetSource;
    }

    @Override
    public String getUri() {
        String xlsUri = this.sheetSource == null ? "" : this.sheetSource.getUri();
        return xlsUri;
    }

    @Override
    public boolean isEmpty(int x, int y) {
        Cell cell = PoiExcelHelper.getCell(x, y, this.getSheet());
        if (cell == null) {
            return true;
        }
        int cellType = cell.getCellType();
        if (cellType == 3) {
            return true;
        }
        if (cellType == 1) {
            String v = cell.getStringCellValue();
            return StringUtils.isBlank((CharSequence)v);
        }
        return false;
    }

    @Override
    public void removeMergedRegion(IGridRegion remove) {
        this.removeMergedRegion(remove.getLeft(), remove.getTop());
    }

    public void removeMergedRegion(int x, int y) {
        Sheet sheet = this.getSheet();
        this.getMergedRegionsPool().remove(x, y);
        int nregions = this.getNumberOfMergedRegions();
        for (int i = 0; i < nregions; ++i) {
            CellRangeAddress reg = PoiExcelHelper.getMergedRegionAt(i, sheet);
            if (reg.getFirstColumn() != x || reg.getFirstRow() != y) continue;
            sheet.removeMergedRegion(i);
            return;
        }
    }

    @Override
    public synchronized void setCellMetaInfo(int col, int row, CellMetaInfo meta) {
        CellKey ck = CellKey.CellKeyFactory.getCellKey(col, row);
        if (meta == null) {
            this.metaInfoMap.remove(ck);
        } else {
            this.metaInfoMap.put(ck, meta);
        }
    }

    @Override
    public void setCellValue(int col, int row, Object value) {
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        if (value != null) {
            boolean writeCellMetaInfo = true;
            if (this.hasEnumDomainMetaInfo(col, row)) {
                writeCellMetaInfo = false;
            }
            if (this.hasRangeDomainMetaInfo(col, row)) {
                writeCellMetaInfo = false;
            }
            AXlsCellWriter cellWriter = this.getCellWriter(value);
            cellWriter.setCellToWrite(poiCell);
            cellWriter.setValueToWrite(value);
            cellWriter.writeCellValue(writeCellMetaInfo);
        } else {
            poiCell.setCellType(3);
        }
    }

    @Override
    public Point setCellValue(Point position, Object value) {
        this.setCellValue(position.getColumn(), position.getRow(), value);
        return position;
    }

    @Override
    public void setCellStringValue(int col, int row, String value) {
        PoiExcelHelper.setCellStringValue(col, row, value, this.getSheet());
    }

    @Override
    public void setCellFormula(int col, int row, String formula) {
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        if (formula != null) {
            AXlsCellWriter cellWriter = this.getCellWriters().get("Formula Writer");
            cellWriter.setCellToWrite(poiCell);
            cellWriter.setValueToWrite(formula);
            cellWriter.writeCellValue(false);
        }
    }

    private Map<String, AXlsCellWriter> getCellWriters() {
        if (this.cellWriters.isEmpty()) {
            this.initCellWriters();
        }
        return this.cellWriters;
    }

    @Override
    public void setCellStyle(int col, int row, ICellStyle style) {
        Object newPoiStyle;
        Sheet sheet = this.getSheet();
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, sheet);
        if (style instanceof XlsCellStyle) {
            newPoiStyle = ((XlsCellStyle)style).getXlsStyle();
            newPoiStyle.cloneStyleFrom(newPoiStyle);
        } else {
            newPoiStyle = PoiExcelHelper.createCellStyle(sheet.getWorkbook());
            CellStyle styleToClone = poiCell.getCellStyle();
            newPoiStyle.cloneStyleFrom(styleToClone);
        }
        poiCell.setCellStyle(newPoiStyle);
    }

    @Override
    public void setCellBorderStyle(int col, int row, ICellStyle style) {
        Sheet sheet = this.getSheet();
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, sheet);
        Object newPoiStyle = PoiExcelHelper.createCellStyle(sheet.getWorkbook());
        newPoiStyle.cloneStyleFrom(poiCell.getCellStyle());
        if (style.getBorderStyle() != null) {
            short[] borderStyle = style.getBorderStyle();
            newPoiStyle.setBorderTop(borderStyle[0]);
            newPoiStyle.setBorderRight(borderStyle[1]);
            newPoiStyle.setBorderBottom(borderStyle[2]);
            newPoiStyle.setBorderLeft(borderStyle[3]);
        }
        if (style.getBorderRGB() != null) {
            PoiExcelHelper.setCellBorderColors(newPoiStyle, style.getBorderRGB(), sheet.getWorkbook());
        }
        poiCell.setCellStyle(newPoiStyle);
    }

    @Override
    public void setCellAlignment(int col, int row, int alignment) {
        Sheet sheet = this.getSheet();
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, sheet);
        CellUtil.setCellStyleProperty((Cell)cell, (Workbook)sheet.getWorkbook(), (String)"alignment", (Object)((short)alignment));
    }

    @Override
    public void setCellIndent(int col, int row, int indent) {
        Sheet sheet = this.getSheet();
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, sheet);
        CellUtil.setCellStyleProperty((Cell)cell, (Workbook)sheet.getWorkbook(), (String)"indention", (Object)((short)indent));
    }

    @Override
    public void setCellFillColor(int col, int row, short[] color) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        CellStyle newStyle = PoiExcelHelper.cloneStyleFrom(cell);
        if (color != null) {
            if (newStyle.getFillPattern() == 0) {
                newStyle.setFillPattern((short)1);
            }
            this.setCellFillColor(newStyle, color);
        } else {
            newStyle.setFillPattern((short)0);
        }
        cell.setCellStyle(newStyle);
    }

    private void setCellFillColor(CellStyle dest, short[] rgb) {
        if (dest instanceof XSSFCellStyle) {
            XSSFColor color = new XSSFColor(new Color(rgb[0], rgb[1], rgb[2]));
            ((XSSFCellStyle)dest).setFillForegroundColor(color);
        } else {
            Short color = this.findIndexedColor(rgb);
            if (color != null) {
                dest.setFillForegroundColor(color.shortValue());
            }
        }
    }

    @Override
    public void setCellFontColor(int col, int row, short[] color) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        CellStyle newStyle = PoiExcelHelper.cloneStyleFrom(cell);
        Font newFont = PoiExcelHelper.cloneFontFrom(cell);
        if (color != null) {
            this.setCellFontColor(newFont, color);
        } else {
            newFont.setColor((short)8);
        }
        newStyle.setFont(newFont);
        cell.setCellStyle(newStyle);
    }

    private void setCellFontColor(Font dest, short[] rgb) {
        if (dest instanceof XSSFFont) {
            XSSFColor color = new XSSFColor(new Color(rgb[0], rgb[1], rgb[2]));
            ((XSSFFont)dest).setColor(color);
        } else {
            Short color = this.findIndexedColor(rgb);
            if (color != null) {
                dest.setColor(color.shortValue());
            }
        }
    }

    private Short findIndexedColor(short[] rgb) {
        HSSFPalette palette = ((HSSFWorkbook)this.getSheet().getWorkbook()).getCustomPalette();
        HSSFColor color = palette.findColor((byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
        if (color == null) {
            Set<Short> usedColors = this.sheetSource.getWorkbookSource().getWorkbookColors();
            short fromIndex = 8;
            short toIndex = (short)(56 + fromIndex);
            for (short colorIndex = fromIndex; colorIndex < toIndex; colorIndex = (short)(colorIndex + 1)) {
                if (usedColors.contains(colorIndex)) continue;
                palette.setColorAtIndex(colorIndex, (byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
                color = palette.getColor(colorIndex);
                usedColors.add(colorIndex);
                break;
            }
            if (color == null) {
                color = palette.findSimilarColor((byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
            }
        }
        return color == null ? null : Short.valueOf(color.getIndex());
    }

    @Override
    public void setCellFontBold(int col, int row, boolean bold) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        short boldweight = bold ? (short)700 : 400;
        PoiExcelHelper.setCellFontBold(cell, boldweight);
    }

    @Override
    public void setCellFontItalic(int col, int row, boolean italic) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        PoiExcelHelper.setCellFontItalic(cell, italic);
    }

    @Override
    public void setCellFontUnderline(int col, int row, boolean underlined) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        byte underline = underlined ? (byte)1 : 0;
        PoiExcelHelper.setCellFontUnderline(cell, underline);
    }

    @Override
    public void setCellComment(int col, int row, ICellComment comment) {
        Comment poiComment = null;
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, this.getSheet());
        if (comment != null) {
            poiComment = ((XlsCellComment)comment).getXlxComment();
        }
        poiCell.setCellComment(poiComment);
    }

    public boolean hasEnumDomainMetaInfo(int col, int row) {
        boolean result = false;
        ICell cell = this.getCell(col, row);
        if (cell != null) {
            IDomain domain;
            IOpenClass dataType;
            CellMetaInfo cellMetaInfo = cell.getMetaInfo();
            IOpenClass iOpenClass = dataType = cellMetaInfo == null ? null : cellMetaInfo.getDataType();
            if (dataType != null && (domain = dataType.getDomain()) instanceof EnumDomain) {
                result = true;
            }
        }
        return result;
    }

    public boolean hasRangeDomainMetaInfo(int col, int row) {
        boolean result = false;
        ICell cell = this.getCell(col, row);
        if (cell != null) {
            IOpenClass dataType;
            CellMetaInfo cellMetaInfo = cell.getMetaInfo();
            IOpenClass iOpenClass = dataType = cellMetaInfo == null ? null : cellMetaInfo.getDataType();
            if (dataType != null && ClassUtils.isAssignable((Class)dataType.getInstanceClass(), INumberRange.class)) {
                result = true;
            }
        }
        return result;
    }

    public AXlsCellWriter getCellWriter(Object value) {
        String strValue;
        Map<String, AXlsCellWriter> cellWriters = this.getCellWriters();
        AXlsCellWriter result = value instanceof Number ? cellWriters.get("Number Writer") : (value instanceof Date ? cellWriters.get("Date Writer") : (value instanceof Boolean ? cellWriters.get("Boolean Writer") : (EnumUtils.isEnum((Object)value) ? cellWriters.get("Enum Writer") : (EnumUtils.isEnumArray((Object)value) ? cellWriters.get("Enum Array Writer") : (value.getClass().isArray() ? cellWriters.get("Array Writer") : ((strValue = String.valueOf(value)).startsWith("=") ? cellWriters.get("Formula Writer") : cellWriters.get("String Writer")))))));
        return result;
    }

    private Sheet getSheet() {
        return this.sheetSource.getSheet();
    }
}

