/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openl.rules.table.syntax.XlsURLConstants;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;

public class XlsUrlParser
implements XlsURLConstants {
    public String wbPath;
    public String wbName;
    public String wsName;
    public String range;
    public String cell;

    public void parse(String url) {
        String file;
        HashMap<String, String> map = new HashMap<String, String>();
        int indexQuestionMark = url.indexOf(63);
        if (indexQuestionMark >= 0) {
            file = url.substring(0, indexQuestionMark);
            String query = url.substring(indexQuestionMark + 1);
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int idx = pair.indexOf(61);
                if (idx < 0) {
                    map.put(pair, "");
                    continue;
                }
                String key = pair.substring(0, idx);
                String value = StringTool.decodeURL((String)pair.substring(idx + 1, pair.length()));
                map.put(key, value);
            }
        } else {
            file = url;
        }
        file = StringTool.decodeURL((String)file);
        this.wsName = (String)map.get("sheet");
        this.range = (String)map.get("range");
        this.cell = (String)map.get("cell");
        if (this.range == null) {
            this.range = this.cell;
        }
        if ("null".equals(file)) {
            this.wbPath = "/unexistingPath/";
            this.wbName = "unexistingSourceFile.xls";
        } else {
            if (file.startsWith("file:/")) {
                file = file.substring(6);
            }
            try {
                File f = new File(file).getCanonicalFile();
                this.wbPath = f.getParent();
                this.wbName = f.getName();
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }
}

