/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.formatters;

import java.util.Date;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.formatters.ArrayFormatter;
import org.openl.rules.table.formatters.FormulaFormatter;
import org.openl.rules.table.xls.XlsCell;
import org.openl.rules.table.xls.formatters.XlsDateFormatter;
import org.openl.rules.table.xls.formatters.XlsNumberFormatter;
import org.openl.types.IOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.util.formatters.BooleanFormatter;
import org.openl.util.formatters.DefaultFormatter;
import org.openl.util.formatters.EnumFormatter;
import org.openl.util.formatters.IFormatter;

public class XlsDataFormatterFactory {
    private static final String GENERAL_FORMAT = "General";
    private static Locale locale = Locale.US;
    private static DataFormatter dataFormatter = new DataFormatter(locale);

    public static IFormatter getFormatter(XlsCell cell) {
        IOpenClass dataType;
        IFormatter formatter = null;
        CellMetaInfo cellMetaInfo = cell.getMetaInfo();
        IOpenClass iOpenClass = dataType = cellMetaInfo == null ? null : cellMetaInfo.getDataType();
        if (dataType != null) {
            Class instanceClass = dataType.getInstanceClass();
            if (ClassUtils.isAssignable((Class)instanceClass, Number.class)) {
                IFormatter numberFormatter = XlsDataFormatterFactory.getNumberFormatter(cell);
                formatter = cellMetaInfo.isMultiValue() ? new ArrayFormatter(numberFormatter) : numberFormatter;
            } else if (instanceClass == Date.class) {
                formatter = XlsDataFormatterFactory.getDateFormatter(cell);
            } else if (ClassUtils.isAssignable((Class)instanceClass, Boolean.class)) {
                BooleanFormatter booleanFormatter = new BooleanFormatter();
                formatter = cellMetaInfo.isMultiValue() ? new ArrayFormatter((IFormatter)booleanFormatter) : booleanFormatter;
            } else if (instanceClass.isEnum()) {
                EnumFormatter enumFormatter = new EnumFormatter(instanceClass);
                formatter = cellMetaInfo.isMultiValue() ? new ArrayFormatter((IFormatter)enumFormatter) : enumFormatter;
            } else {
                formatter = new DefaultFormatter();
            }
            if (cell.getFormula() != null) {
                formatter = new FormulaFormatter(formatter);
            }
        }
        return formatter;
    }

    private static IFormatter getNumberFormatter(XlsCell cell) {
        CellStyle xlsStyle;
        XlsNumberFormatter formatter = null;
        Cell xlsCell = cell.getXlsCell();
        CellStyle cellStyle = xlsStyle = xlsCell != null ? xlsCell.getCellStyle() : null;
        if (xlsStyle != null) {
            short formatIndex = xlsStyle.getDataFormat();
            String format = xlsStyle.getDataFormatString();
            if (format.contains("#\" \"")) {
                format = format.replaceAll("#\" \"", "# ");
            }
            formatter = new XlsNumberFormatter(formatIndex, format, dataFormatter, locale);
        }
        return formatter;
    }

    private static IFormatter getDateFormatter(XlsCell cell) {
        CellStyle xlsStyle;
        XlsDateFormatter formatter = null;
        Cell xlsCell = cell.getXlsCell();
        CellStyle cellStyle = xlsStyle = xlsCell != null ? xlsCell.getCellStyle() : null;
        if (xlsStyle != null) {
            String format = xlsStyle.getDataFormatString();
            if (StringUtils.isBlank((CharSequence)format) || format.equals(GENERAL_FORMAT)) {
                format = "m/d/yy";
            }
            formatter = new XlsDateFormatter(format);
        }
        return formatter;
    }
}

