/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.formatters;

import java.util.Locale;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.openl.util.formatters.IFormatter;
import org.openl.util.formatters.NumberFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XlsNumberFormatter
implements IFormatter {
    private final Logger log = LoggerFactory.getLogger(XlsNumberFormatter.class);
    private int formatIndex;
    private String format;
    private DataFormatter dataFormatter;
    private Locale locale;

    public XlsNumberFormatter(int xlsFormatIndex, String xlsFormat, DataFormatter xlsDataFormatter, Locale locale) {
        this.formatIndex = xlsFormatIndex;
        this.format = xlsFormat;
        this.dataFormatter = xlsDataFormatter;
        this.locale = locale;
    }

    public String format(Object value) {
        if (!(value instanceof Number)) {
            this.log.debug("Should be Number: {}", value);
            return null;
        }
        double doubleValue = ((Number)value).doubleValue();
        String formattedDate = this.dataFormatter.formatRawCellContents(doubleValue, this.formatIndex, this.format);
        if (this.format.startsWith("# ?/") || this.format.startsWith("# ??/") || this.format.startsWith("# ???/")) {
            if (doubleValue < 1.0 && doubleValue > 0.0) {
                formattedDate = formattedDate.substring(2);
            } else if (doubleValue < 0.0 && doubleValue > -1.0) {
                formattedDate = "-" + formattedDate.substring(3);
            }
        }
        return formattedDate;
    }

    public Object parse(String value) {
        NumberFormatter numberFormatter = new NumberFormatter(this.locale);
        return numberFormatter.parse(value);
    }
}

