/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmRow;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.IRowParser;
import org.openl.rules.tbasic.TableParserSpecificationBean;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public class RowParser
implements IRowParser {
    private static final String COMMENTS_REGEXP = "^(//)(.*)|^(/\\*)(.*)(\\*/)$";
    private static final String CONDITION = "Condition";
    private static final String ACTION = "Action";
    private static final String BEFORE = "Before";
    private static final String AFTER = "After";
    private List<AlgorithmRow> rows;
    private TableParserSpecificationBean[] specifications;

    public RowParser(List<AlgorithmRow> rows, TableParserSpecificationBean[] specifications) {
        assert (rows != null);
        assert (specifications != null);
        this.rows = rows;
        this.specifications = specifications;
    }

    private void checkRowValue(String columnName, StringValue columnValue, TableParserSpecificationBean.ValueNecessity columnNecessity) throws SyntaxNodeException {
        if (columnNecessity == TableParserSpecificationBean.ValueNecessity.REQUIRED && columnValue.isEmpty()) {
            String errMsg = String.format("Operation must have value in %s!", columnName);
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, (IOpenSourceCodeModule)columnValue.asSourceCodeModule());
        }
        if (columnNecessity == TableParserSpecificationBean.ValueNecessity.PROHIBITED && !columnValue.isEmpty()) {
            String errMsg = String.format("Operation must not have value in %s!", columnName);
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, (IOpenSourceCodeModule)columnValue.asSourceCodeModule());
        }
    }

    private TableParserSpecificationBean getSpecification(StringValue operation, boolean multiline) throws SyntaxNodeException {
        String operationName = operation.getValue();
        boolean foundButNotMatch = false;
        for (TableParserSpecificationBean specification : this.specifications) {
            String specKeyword = specification.getKeyword();
            if (!operationName.equalsIgnoreCase(specKeyword)) continue;
            if (specification.isMultiline() == multiline) {
                return specification;
            }
            foundButNotMatch = true;
        }
        if (foundButNotMatch) {
            String errorMessage = multiline ? "Operation %s can not be multiline! Nested operations are not allowed here." : "Operation %s can not be singleline!";
            throw SyntaxNodeExceptionUtils.createError((String)String.format(errorMessage, operationName), (IOpenSourceCodeModule)operation.asSourceCodeModule());
        }
        String errMsg = "No such operation: " + operationName;
        throw SyntaxNodeExceptionUtils.createError((String)errMsg, (IOpenSourceCodeModule)operation.asSourceCodeModule());
    }

    private boolean[] guessMultiline(List<AlgorithmTreeNode> nodes) {
        int size = nodes.size();
        boolean[] multilines = new boolean[size];
        for (int i = 0; i < size - 1; ++i) {
            AlgorithmTreeNode nextNode;
            AlgorithmRow nextRow;
            int i2;
            AlgorithmTreeNode node = nodes.get(i);
            AlgorithmRow row = node.getAlgorithmRow();
            int i1 = row.getOperationLevel();
            multilines[i] = i1 < (i2 = (nextRow = (nextNode = nodes.get(i + 1)).getAlgorithmRow()).getOperationLevel());
        }
        return multilines;
    }

    @Override
    public List<AlgorithmTreeNode> parse() throws SyntaxNodeException {
        List<AlgorithmTreeNode> nodes = this.prepareNodes();
        boolean[] guessedMultilines = this.guessMultiline(nodes);
        ArrayList<AlgorithmTreeNode> treeNodes = new ArrayList<AlgorithmTreeNode>();
        HashMap<Integer, AlgorithmTreeNode> parentTree = new HashMap<Integer, AlgorithmTreeNode>();
        int prevIndent = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            AlgorithmTreeNode node = nodes.get(i);
            AlgorithmRow row = node.getAlgorithmRow();
            TableParserSpecificationBean specification = this.validateRow(row, guessedMultilines[i]);
            node.setSpecification(specification);
            int indent = row.getOperationLevel();
            if (indent == 0) {
                treeNodes.add(node);
                parentTree.clear();
            } else {
                StringValue operation = row.getOperation();
                if (indent > prevIndent + 1) {
                    String errMsg = String.format("Incorrect operation indention! Expected %d.", prevIndent + 1);
                    throw SyntaxNodeExceptionUtils.createError((String)errMsg, (IOpenSourceCodeModule)operation.asSourceCodeModule());
                }
                if (parentTree.isEmpty()) {
                    String errMsg = "Incorrect operation indention! Could not find parent operation with 0 indention.";
                    throw SyntaxNodeExceptionUtils.createError((String)errMsg, (IOpenSourceCodeModule)operation.asSourceCodeModule());
                }
                ((AlgorithmTreeNode)parentTree.get(indent - 1)).add(node);
            }
            parentTree.put(indent, node);
            prevIndent = indent;
        }
        return treeNodes;
    }

    private List<AlgorithmTreeNode> prepareNodes() {
        ArrayList<AlgorithmTreeNode> nodes = new ArrayList<AlgorithmTreeNode>();
        AlgorithmTreeNode lastNode = new AlgorithmTreeNode();
        for (AlgorithmRow row : this.rows) {
            StringValue operation = row.getOperation();
            StringValue label = row.getLabel();
            if (operation == null) {
                throw new OpenlNotCheckedException(String.format("There is no operations in row '%s'", row.getDescription()));
            }
            if (operation.isEmpty()) {
                if (label.isEmpty()) continue;
                lastNode.addLabel(label);
                continue;
            }
            if (operation.getValue().matches(COMMENTS_REGEXP)) continue;
            if (!label.isEmpty()) {
                lastNode.addLabel(label);
            } else if (lastNode.getLabels().isEmpty()) {
                lastNode.addLabel(label);
            }
            lastNode.setAlgorithmRow(row);
            nodes.add(lastNode);
            lastNode = new AlgorithmTreeNode();
        }
        if (lastNode.getAlgorithmRow() != null) {
            nodes.add(lastNode);
        }
        return nodes;
    }

    private TableParserSpecificationBean validateRow(AlgorithmRow row, boolean guessedMultiline) throws SyntaxNodeException {
        StringValue operation = row.getOperation();
        TableParserSpecificationBean spec = this.getSpecification(operation, guessedMultiline);
        if (spec.getLabel() == TableParserSpecificationBean.ValueNecessity.REQUIRED && row.getLabel().isEmpty()) {
            String errMsg = "Label is obligatory for this operation!";
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, (IOpenSourceCodeModule)row.getLabel().asSourceCodeModule());
        }
        this.checkRowValue(CONDITION, row.getCondition(), spec.getCondition());
        this.checkRowValue(ACTION, row.getAction(), spec.getAction());
        this.checkRowValue(BEFORE, row.getBefore(), spec.getBeforeAndAfter());
        this.checkRowValue(AFTER, row.getAfter(), spec.getBeforeAndAfter());
        int indent = row.getOperationLevel();
        TableParserSpecificationBean.ValueNecessity specTopLevel = spec.getTopLevel();
        if (specTopLevel == TableParserSpecificationBean.ValueNecessity.PROHIBITED && indent == 0) {
            throw SyntaxNodeExceptionUtils.createError((String)"Operation can not be a top level element! It should be nested.", (IOpenSourceCodeModule)operation.asSourceCodeModule());
        }
        if (specTopLevel == TableParserSpecificationBean.ValueNecessity.REQUIRED && indent > 0) {
            throw SyntaxNodeExceptionUtils.createError((String)"Operation can be a top level only!", (IOpenSourceCodeModule)operation.asSourceCodeModule());
        }
        return spec;
    }
}

