/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.List;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmFunction;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgoritmNodesCompiler;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ReturnAnalyzer;
import org.openl.rules.tbasic.compile.SuitablityAsReturn;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;

public class AlgorithmFunctionCompiler {
    private List<AlgorithmTreeNode> functionBody;
    private CompileContext compileContext;
    private AlgorithmCompiler compiler;
    private AlgorithmFunction method;

    public AlgorithmFunctionCompiler(List<AlgorithmTreeNode> functionBody, CompileContext compileContext, AlgorithmFunction method, AlgorithmCompiler compiler) {
        this.functionBody = functionBody;
        this.compileContext = compileContext;
        this.method = method;
        this.compiler = compiler;
    }

    private void analyzeReturnCorrectness() throws SyntaxNodeException {
        if (this.functionBody.size() > 0) {
            int i = 0;
            for (AlgorithmTreeNode algorithmTreeNode : this.functionBody) {
                SuitablityAsReturn status;
                StringValue operation = algorithmTreeNode.getAlgorithmRow().getOperation();
                if (operation != null && TBasicSpecificationKey.RETURN.toString().equals(operation.toString()) && (status = new ReturnAnalyzer(this.getReturnType(), this.compiler).analyze(this.functionBody.get(i).getChildren())) == SuitablityAsReturn.NONE) {
                    IOpenSourceCodeModule errorSource = this.functionBody.get(i).getAlgorithmRow().getOperation().asSourceCodeModule();
                    throw SyntaxNodeExceptionUtils.createError((String)("The method must return value of type '" + this.getReturnType().getDisplayName(1) + "'"), (IOpenSourceCodeModule)errorSource);
                }
                ++i;
            }
        }
    }

    public void compile() throws Exception {
        this.compileContext.addOperations(new AlgoritmNodesCompiler(this.getReturnType(), this.compileContext, this.compiler).compileNodes(this.functionBody));
        this.analyzeReturnCorrectness();
    }

    public IOpenClass getReturnType() {
        return this.method.getHeader().getType();
    }

    public void postprocess() {
        this.method.setAlgorithmSteps(this.compileContext.getOperations());
        this.method.setLabels(this.compileContext.getLocalLabelsRegister());
    }
}

