/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.List;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ConversionRulesController;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.rules.tbasic.compile.OperationFactory;
import org.openl.rules.tbasic.compile.OperationType;
import org.openl.rules.tbasic.compile.ParameterConverterManager;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;

public class AlgoritmNodesCompiler {
    private LabelManager labelManager;
    private CompileContext currentCompileContext;
    private ParameterConverterManager parameterConverter;
    private OperationFactory operationFactory;
    private List<OperationAnalyzer> operationAnalyzers = new ArrayList<OperationAnalyzer>();

    public AlgoritmNodesCompiler(IOpenClass returnType, CompileContext currentCompileContext, AlgorithmCompiler compiler) {
        this.operationAnalyzers.add(new CommonOperations());
        this.operationAnalyzers.add(new NotCompileOperations());
        this.operationAnalyzers.add(new NotCheckLabelOperations());
        this.labelManager = compiler.getLabelManager();
        this.currentCompileContext = currentCompileContext;
        this.parameterConverter = new ParameterConverterManager(compiler, returnType);
        this.operationFactory = new OperationFactory(this.parameterConverter);
    }

    public List<RuntimeOperation> compileNodes(List<AlgorithmTreeNode> nodes) throws Exception {
        return this.compileNestedNodes(nodes);
    }

    private List<RuntimeOperation> compileNestedNodes(List<AlgorithmTreeNode> nodesToProcess) throws Exception {
        int linkedNodesGroupSize;
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        for (int i = 0; i < nodesToProcess.size(); i += linkedNodesGroupSize) {
            if (this.hasUnreachableCode(nodesToProcess, i)) {
                IOpenSourceCodeModule errorSource = nodesToProcess.get(i + 1).getAlgorithmRow().getOperation().asSourceCodeModule();
                throw SyntaxNodeExceptionUtils.createError((String)"Unreachable code. Operations after BREAK,CONTINUE not allowed.", (IOpenSourceCodeModule)errorSource);
            }
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToProcess, i);
            List<AlgorithmTreeNode> nodesToCompile = nodesToProcess.subList(i, i + linkedNodesGroupSize);
            emittedOperations.addAll(this.compileLinkedNodesGroup(nodesToCompile));
        }
        return emittedOperations;
    }

    private List<RuntimeOperation> compileLinkedNodesGroup(List<AlgorithmTreeNode> nodesToCompile) throws Exception {
        List<StringValue> userDefinedLabels;
        assert (nodesToCompile.size() > 0);
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        ConversionRuleBean conversionRule = ConversionRulesController.getInstance().getConvertionRule(nodesToCompile);
        boolean isLoopOperation = nodesToCompile.get(0).getSpecification().isLoopOperation();
        this.labelManager.startOperationsSet(isLoopOperation);
        this.labelManager.generateAllLabels(conversionRule.getLabel());
        RuntimeOperation beforeOperation = this.compileBefore(nodesToCompile);
        if (beforeOperation != null) {
            emittedOperations.add(beforeOperation);
        }
        for (ConversionRuleStep convertionStep : conversionRule.getConvertionSteps()) {
            List<RuntimeOperation> stepEmittedOperations = this.processConversionStep(nodesToCompile, convertionStep);
            emittedOperations.addAll(stepEmittedOperations);
        }
        RuntimeOperation afterOperation = this.compileAfter(nodesToCompile);
        if (afterOperation != null) {
            emittedOperations.add(afterOperation);
        }
        if (!(userDefinedLabels = nodesToCompile.get(0).getLabels()).isEmpty() && emittedOperations.size() > 0) {
            for (StringValue userDefinedLabel : userDefinedLabels) {
                this.currentCompileContext.setLabel(userDefinedLabel.getValue(), (RuntimeOperation)emittedOperations.get(0));
            }
        }
        this.labelManager.finishOperationsSet();
        return emittedOperations;
    }

    private RuntimeOperation compileAfter(List<AlgorithmTreeNode> nodesToCompile) throws Exception {
        String afterFieldName = "after";
        return this.createOperationForFirstNodeField(nodesToCompile, "after");
    }

    private RuntimeOperation compileBefore(List<AlgorithmTreeNode> nodesToCompile) throws Exception {
        String beforeFieldName = "before";
        return this.createOperationForFirstNodeField(nodesToCompile, "before");
    }

    private RuntimeOperation createOperationForFirstNodeField(List<AlgorithmTreeNode> nodesToCompile, String fieldName) throws Exception {
        String param = nodesToCompile.get(0).getAlgorithmRow().getOperation() + "." + fieldName;
        StringValue content = AlgorithmCompilerTool.getCellContent(nodesToCompile, param);
        RuntimeOperation operation = null;
        if (content.getValue() != null && !content.getValue().trim().isEmpty()) {
            ConversionRuleStep conversionStep = new ConversionRuleStep("Perform", param, null, null, fieldName + " execution");
            operation = this.operationFactory.createOperation(nodesToCompile, conversionStep);
        }
        return operation;
    }

    private boolean hasUnreachableCode(List<AlgorithmTreeNode> nodesToProcess, int indexOfReturn) {
        return indexOfReturn < nodesToProcess.size() - 1 && (TBasicSpecificationKey.BREAK.toString().equals(nodesToProcess.get(indexOfReturn).getSpecificationKeyword()) || TBasicSpecificationKey.CONTINUE.toString().equals(nodesToProcess.get(indexOfReturn).getSpecificationKeyword()));
    }

    private List<RuntimeOperation> processConversionStep(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
        assert (nodesToCompile.size() > 0);
        assert (conversionStep != null);
        String label = null;
        if (conversionStep.getLabelInstruction() != null) {
            label = this.labelManager.getLabelByInstruction(conversionStep.getLabelInstruction());
        }
        String operationType = conversionStep.getOperationType();
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        for (OperationAnalyzer analyzer : this.operationAnalyzers) {
            List<RuntimeOperation> operations;
            if (!analyzer.suits(operationType) || (operations = analyzer.getOperations(nodesToCompile, conversionStep)) == null) continue;
            emittedOperations.addAll(operations);
        }
        if (emittedOperations.size() > 0 && label != null) {
            this.currentCompileContext.registerNewLabel(label, nodesToCompile.get(0));
            this.currentCompileContext.setLabel(label, (RuntimeOperation)emittedOperations.get(0));
        }
        return emittedOperations;
    }

    private final class NotCheckLabelOperations
    implements OperationAnalyzer {
        private NotCheckLabelOperations() {
        }

        @Override
        public boolean suits(String operationType) {
            return operationType.equals(OperationType.CHECK_LABEL.toString());
        }

        @Override
        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
            String labelName = (String)AlgoritmNodesCompiler.this.parameterConverter.convertParam(nodesToCompile, String.class, conversionStep.getOperationParam1());
            if (!AlgoritmNodesCompiler.this.currentCompileContext.isLabelRegistered(labelName)) {
                IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
                String errorMessage = String.format("Such label is not available from this place: \"%s\".", labelName);
                throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (IOpenSourceCodeModule)errorSource);
            }
            return null;
        }
    }

    private final class NotCompileOperations
    implements OperationAnalyzer {
        private NotCompileOperations() {
        }

        @Override
        public boolean suits(String operationType) {
            return operationType.equals(OperationType.COMPILE.toString());
        }

        @Override
        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
            ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
            List<AlgorithmTreeNode> nodesToProcess = AlgorithmCompilerTool.getNestedInstructionsBlock(nodesToCompile, conversionStep.getOperationParam1());
            emittedOperations.addAll(AlgoritmNodesCompiler.this.compileNestedNodes(nodesToProcess));
            return emittedOperations;
        }
    }

    private final class CommonOperations
    implements OperationAnalyzer {
        private CommonOperations() {
        }

        @Override
        public boolean suits(String operationType) {
            return !operationType.startsWith("!");
        }

        @Override
        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
            ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
            RuntimeOperation emittedOperation = AlgoritmNodesCompiler.this.operationFactory.createOperation(nodesToCompile, conversionStep);
            emittedOperations.add(emittedOperation);
            return emittedOperations;
        }
    }

    public static interface OperationAnalyzer {
        public boolean suits(String var1);

        public List<RuntimeOperation> getOperations(List<AlgorithmTreeNode> var1, ConversionRuleStep var2) throws Exception;
    }
}

