/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.List;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmTableParserManager;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.SuitablityAsReturn;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class ReturnAnalyzer {
    private IOpenClass returnType;
    private AlgorithmCompiler compiler;

    public ReturnAnalyzer(IOpenClass returnType, AlgorithmCompiler compiler) {
        this.returnType = returnType;
        this.compiler = compiler;
    }

    public SuitablityAsReturn analyze(List<AlgorithmTreeNode> nodesToAnalyze) throws SyntaxNodeException {
        if (this.returnType != JavaOpenClass.VOID) {
            return this.analyzeSequence(nodesToAnalyze);
        }
        return SuitablityAsReturn.RETURN;
    }

    private SuitablityAsReturn analyzeGroup(List<AlgorithmTreeNode> nodesToAnalyze) throws SyntaxNodeException {
        if (TBasicSpecificationKey.IF.toString().equals(nodesToAnalyze.get(0).getSpecificationKeyword()) && TBasicSpecificationKey.ELSE.toString().equals(nodesToAnalyze.get(1).getSpecificationKeyword())) {
            return this.analyzeIFOperation(nodesToAnalyze, nodesToAnalyze.get(0).getSpecification().isMultiline());
        }
        return SuitablityAsReturn.NONE;
    }

    private SuitablityAsReturn analyzeIFOperation(List<AlgorithmTreeNode> nodesToAnalyze, boolean isMultiline) throws SyntaxNodeException {
        SuitablityAsReturn result = SuitablityAsReturn.RETURN;
        for (int i = 0; i < 2; ++i) {
            SuitablityAsReturn suitablityOfNode = isMultiline ? this.analyzeSequence(nodesToAnalyze.get(i).getChildren()) : (this.hasTypeAsReturn(nodesToAnalyze.get(i).getAlgorithmRow().getAction()) ? SuitablityAsReturn.SUITABLE : SuitablityAsReturn.NONE);
            result = SuitablityAsReturn.lessSuitable(result, suitablityOfNode);
        }
        return result;
    }

    private SuitablityAsReturn analyzeNode(AlgorithmTreeNode nodeToAnalyze) throws SyntaxNodeException {
        if (TBasicSpecificationKey.RETURN.toString().equals(nodeToAnalyze.getSpecificationKeyword())) {
            if (this.hasTypeAsReturn(nodeToAnalyze.getAlgorithmRow().getCondition())) {
                return SuitablityAsReturn.RETURN;
            }
            IOpenSourceCodeModule errorSource = nodeToAnalyze.getAlgorithmRow().getCondition().asSourceCodeModule();
            throw SyntaxNodeExceptionUtils.createError((String)("Incorrect return type. Return type of function declared as '" + this.returnType.getDisplayName(1) + "'"), (IOpenSourceCodeModule)errorSource);
        }
        if (this.canBeGrouped(nodeToAnalyze)) {
            return SuitablityAsReturn.NONE;
        }
        if (this.hasTypeAsReturn(nodeToAnalyze.getAlgorithmRow().getAction())) {
            return SuitablityAsReturn.SUITABLE;
        }
        return SuitablityAsReturn.NONE;
    }

    private SuitablityAsReturn analyzeSequence(List<AlgorithmTreeNode> nodesToAnalyze) throws SyntaxNodeException {
        int linkedNodesGroupSize;
        SuitablityAsReturn result = SuitablityAsReturn.RETURN;
        for (int i = 0; i < nodesToAnalyze.size(); i += linkedNodesGroupSize) {
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToAnalyze, i);
            result = linkedNodesGroupSize == 1 ? this.analyzeNode(nodesToAnalyze.get(i)) : this.analyzeGroup(nodesToAnalyze.subList(i, i + linkedNodesGroupSize));
            if (result != SuitablityAsReturn.RETURN || i + linkedNodesGroupSize >= nodesToAnalyze.size()) continue;
            IOpenSourceCodeModule errorSource = nodesToAnalyze.get(i + linkedNodesGroupSize).getAlgorithmRow().getOperation().asSourceCodeModule();
            throw SyntaxNodeExceptionUtils.createError((String)"Unreachable code. Operations after RETURN not allowed.", (IOpenSourceCodeModule)errorSource);
        }
        return result;
    }

    private boolean canBeGrouped(AlgorithmTreeNode nodeToAnalyze) {
        String currentNodeKeyword = nodeToAnalyze.getSpecificationKeyword();
        String[] operationNamesToGroup = AlgorithmTableParserManager.instance().whatOperationsToGroup(currentNodeKeyword);
        return operationNamesToGroup != null;
    }

    public IOpenClass getReturnType() {
        return this.returnType;
    }

    private IOpenClass getTypeOfField(StringValue fieldContent) {
        return this.compiler.getTypeOfField(fieldContent);
    }

    private boolean hasTypeAsReturn(StringValue fieldContent) {
        if (this.returnType == JavaOpenClass.VOID) {
            return fieldContent.getValue().equals("");
        }
        IOpenClass typeOfField = this.getTypeOfField(fieldContent);
        return this.returnType.equals(typeOfField);
    }
}

