/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodDelegator;

public final class ProjectHelper {
    private ProjectHelper() {
    }

    public static TestSuiteMethod[] allTesters(IOpenClass openClass) {
        ArrayList<TestSuiteMethod> res = new ArrayList<TestSuiteMethod>();
        for (IOpenMethod tester : openClass.getMethods()) {
            if (ProjectHelper.isTester(tester)) {
                res.add((TestSuiteMethod)tester);
            }
            if (!(tester instanceof OpenMethodDispatcher) || !ProjectHelper.isTester(((OpenMethodDispatcher)tester).getTargetMethod())) continue;
            res.add((TestSuiteMethod)((OpenMethodDispatcher)tester).getTargetMethod());
        }
        TestSuiteMethod[] testSuiteMethods = new TestSuiteMethod[res.size()];
        return res.toArray(testSuiteMethods);
    }

    public static boolean isTester(IOpenMethod tester) {
        if (tester instanceof TestSuiteMethod) {
            TestSuiteMethod testSuiteMethod = (TestSuiteMethod)tester;
            return !testSuiteMethod.isRunmethod() && testSuiteMethod.isRunmethodTestable() && !testSuiteMethod.getSyntaxNode().hasErrors();
        }
        return false;
    }

    public static IOpenMethod[] testers(IOpenMethod tested) {
        ArrayList<IOpenMethod> res = new ArrayList<IOpenMethod>();
        for (IOpenMethod tester : tested.getDeclaringClass().getMethods()) {
            if (!ProjectHelper.isTester(tester) || !ProjectHelper.isTestForMethod(tester, tested)) continue;
            res.add(tester);
        }
        return res.toArray(new IOpenMethod[res.size()]);
    }

    public static boolean isTestForMethod(IOpenMethod tester, IOpenMethod tested) {
        if (!(tester instanceof TestSuiteMethod)) {
            return false;
        }
        IOpenMethod toTest = ((TestSuiteMethod)tester).getTestedMethod();
        if (toTest == tested) {
            return true;
        }
        if (toTest instanceof OpenMethodDispatcher && ((OpenMethodDispatcher)toTest).getCandidates().contains(tested)) {
            return true;
        }
        if (tested instanceof MethodDelegator) {
            return ProjectHelper.isTestForMethod(tester, tested.getMethod());
        }
        if (tested instanceof OpenMethodDispatcher) {
            return ProjectHelper.isTestForMethod(tester, ((OpenMethodDispatcher)tested).getTargetMethod());
        }
        return false;
    }

    public static String getTestInfo(IOpenMethod testMethod) {
        String info = null;
        if (testMethod instanceof TestSuiteMethod) {
            TestSuiteMethod testSuite = (TestSuiteMethod)testMethod;
            int numberOfTests = testSuite.getNumberOfTests();
            info = testSuite.isRunmethod() ? (numberOfTests < 1 ? "No runs" : numberOfTests + " runs") : (numberOfTests < 1 ? "No test cases" : numberOfTests + " test cases");
        }
        return info;
    }
}

