/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.Map;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.table.formatters.FormattersManager;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestUnit;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DynamicObject;
import org.openl.util.Log;
import org.openl.vm.IRuntimeEnv;

public class TestDescription {
    private static final String PRECISION_PARAM = "precision";
    private ParameterWithValueDeclaration[] executionParams;
    private IOpenMethod testedMethod;
    private DynamicObject testObject;
    private Map<String, Object> testTableProps = null;
    private int index;
    protected ColumnDescriptor[] columnDescriptors;
    private OpenLArgumentsCloner cloner = new OpenLArgumentsCloner();

    public TestDescription(IOpenMethod testedMethod, DynamicObject testObject) {
        this.testedMethod = testedMethod;
        this.testObject = testObject;
        this.executionParams = this.initExecutionParams();
    }

    public TestDescription(IOpenMethod testedMethod, DynamicObject testObject, Map<String, Object> testTableProps, ColumnDescriptor[] columnDescriptors) {
        this(testedMethod, testObject);
        this.testTableProps = testTableProps;
        this.columnDescriptors = columnDescriptors;
    }

    public TestDescription(IOpenMethod testedMethod, Object[] arguments) {
        this(testedMethod, arguments, null, null);
    }

    public TestDescription(IOpenMethod testedMethod, Object[] arguments, Object expectedResult, String expectedError) {
        this(testedMethod, TestDescription.createTestObject(testedMethod, arguments, expectedResult, expectedError, null, null));
    }

    public TestDescription(IOpenMethod testedMethod, Object[] arguments, Object expectedResult, String expectedError, IRulesRuntimeContext context) {
        this(testedMethod, TestDescription.createTestObject(testedMethod, arguments, expectedResult, expectedError, context, null));
    }

    public TestDescription(IOpenMethod testedMethod, Object[] arguments, Object expectedResult, String expectedError, IRulesRuntimeContext context, String description) {
        this(testedMethod, TestDescription.createTestObject(testedMethod, arguments, expectedResult, expectedError, context, description));
    }

    public static DynamicObject createTestObject(IOpenMethod testedMethod, Object[] arguments, Object expectedResult, String expectedError, IRulesRuntimeContext context, String description) {
        DynamicObject testObj = new DynamicObject();
        for (int i = 0; i < testedMethod.getSignature().getNumberOfParameters(); ++i) {
            String paramName = testedMethod.getSignature().getParameterName(i);
            testObj.setFieldValue(paramName, arguments[i]);
        }
        if (description != null) {
            testObj.setFieldValue("_description_", (Object)context);
        }
        if (context != null) {
            testObj.setFieldValue("_context_", (Object)context);
        }
        if (expectedResult != null) {
            testObj.setFieldValue("_res_", (Object)context);
        }
        if (expectedError != null) {
            testObj.setFieldValue("_error_", (Object)context);
        }
        return testObj;
    }

    public IOpenMethod getTestedMethod() {
        return this.testedMethod;
    }

    public DynamicObject getTestObject() {
        return this.testObject;
    }

    public ParameterWithValueDeclaration[] getExecutionParams() {
        return this.executionParams;
    }

    public String[] getParametersNames() {
        String[] names = new String[this.executionParams.length];
        for (int i = 0; i < this.executionParams.length; ++i) {
            names[i] = this.executionParams[i].getName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getArguments() {
        Object[] args = new Object[this.executionParams.length];
        for (int i = 0; i < args.length; ++i) {
            Object value = this.executionParams[i].getValue();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (value != null) {
                    Thread.currentThread().setContextClassLoader(value.getClass().getClassLoader());
                }
                try {
                    args[i] = this.cloner.deepClone(value);
                }
                catch (RuntimeException e) {
                    Log.error((String)"Failed to clone an argument \"{0}\". Original argument will be used.", (Object[])new Object[]{this.executionParams[i].getName()});
                    args[i] = value;
                }
                continue;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        return args;
    }

    protected ParameterWithValueDeclaration[] initExecutionParams() {
        ParameterWithValueDeclaration[] executionParams = new ParameterWithValueDeclaration[this.testedMethod.getSignature().getNumberOfParameters()];
        for (int i = 0; i < executionParams.length; ++i) {
            String paramName = this.testedMethod.getSignature().getParameterName(i);
            Object paramValue = this.testObject.getFieldValue(paramName);
            IOpenClass paramType = this.testedMethod.getSignature().getParameterType(i);
            executionParams[i] = new ParameterWithValueDeclaration(paramName, paramValue, paramType);
        }
        return executionParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestUnit runTest(Object target, IRuntimeEnv env, long ntimes) {
        if (ntimes <= 0L) {
            return this.runTest(target, env, 1L);
        }
        Object res = null;
        Throwable exception = null;
        IRuntimeContext oldContext = env.getContext();
        try {
            IRulesRuntimeContext context = this.getRuntimeContext();
            env.setContext((IRuntimeContext)context);
            Object[] args = this.getArguments();
            int j = 0;
            while ((long)j < ntimes) {
                res = this.testedMethod.invoke(target, args, env);
                ++j;
            }
        }
        catch (Throwable t) {
            Log.error((Object)("Testing " + this), (Throwable)t);
            exception = t;
        }
        finally {
            env.setContext(oldContext);
        }
        return exception == null ? new TestUnit(this, res) : new TestUnit(this, exception);
    }

    public Object getArgumentValue(String paramName) {
        return this.testObject.getFieldValue(paramName);
    }

    public boolean hasDescription() {
        return this.testObject.containsField("_description_");
    }

    public String getDescription() {
        return (String)this.getArgumentValue("_description_");
    }

    public boolean isExpectedResultDefined() {
        return this.testObject.containsField("_res_") || this.testObject.getType().getField("_res_") != null;
    }

    public Object getExpectedResult() {
        return this.getArgumentValue("_res_");
    }

    public boolean isExpectedErrorDefined() {
        return this.testObject.containsField("_error_");
    }

    public String getExpectedError() {
        return (String)this.getArgumentValue("_error_");
    }

    public boolean isRuntimeContextDefined() {
        return this.testObject.containsField("_context_");
    }

    public IRulesRuntimeContext getRuntimeContext() {
        IRulesRuntimeContext context = (IRulesRuntimeContext)this.getArgumentValue("_context_");
        try {
            return (IRulesRuntimeContext)this.cloner.deepClone(context);
        }
        catch (Exception e) {
            Log.error((Object)"Failed to clone context. Original context will be used.");
            return context;
        }
    }

    public String toString() {
        String description = this.getDescription();
        if (description == null) {
            if (this.testedMethod.getSignature().getNumberOfParameters() > 0) {
                String name = this.testedMethod.getSignature().getParameterName(0);
                Object value = this.testObject.getFieldValue(name);
                description = FormattersManager.format(value);
            } else {
                description = "Run with no parameters";
            }
        }
        return description;
    }

    public Integer getTestTablePrecision() {
        if (this.testTableProps != null) {
            return this.testTableProps.containsKey(PRECISION_PARAM) ? Integer.valueOf(Integer.parseInt(this.testTableProps.get(PRECISION_PARAM).toString())) : null;
        }
        return null;
    }

    public String getId() {
        if (this.hasId()) {
            return String.valueOf(this.getArgumentValue("_id_"));
        }
        return String.valueOf(this.index + 1);
    }

    public boolean hasId() {
        return this.testObject.containsField("_id_");
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        return this.columnDescriptors;
    }

    public Map<String, Object> getTestTableProps() {
        return this.testTableProps;
    }
}

