/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.base.INamedThing;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ITableModel;
import org.openl.rules.data.PrecisionFieldChain;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.testmethod.TestUnitResultComparator;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.AOpenField;
import org.openl.types.impl.DatatypeArrayElementField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.vm.IRuntimeEnv;

public class TestUnitsResults
implements INamedThing {
    private TestSuite testSuite;
    private ArrayList<TestUnit> testUnits = new ArrayList();

    public TestUnitsResults(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public String getName() {
        return this.testSuite.getDisplayName(0);
    }

    public String getDisplayName(int mode) {
        return this.testSuite.getDisplayName(mode);
    }

    public ArrayList<TestUnit> getTestUnits() {
        return this.testUnits;
    }

    public List<TestUnit> getFilteredTestUnits(boolean failuresOnly, int size) {
        if (this.testUnits != null && failuresOnly) {
            ArrayList<TestUnit> failedUnits = new ArrayList<TestUnit>();
            for (TestUnit testUnit : this.testUnits) {
                if (testUnit.compareResult() == 0 || failedUnits.size() >= size && size != -1) continue;
                failedUnits.add(testUnit);
            }
            return failedUnits;
        }
        return this.testUnits;
    }

    public void addTestUnit(TestUnit testUnit) {
        if (!this.testSuite.isVirtualTestSuite()) {
            this.testUnits.add(this.updateTestUnit(testUnit));
        } else {
            this.testUnits.add(testUnit);
        }
    }

    private static int getArrayIndex(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        String txtIndex = fieldName.substring(fieldName.indexOf("[") + 1, fieldName.indexOf("]"));
        return Integer.parseInt(txtIndex);
    }

    private static String getArrayName(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        return fieldName.substring(0, fieldName.indexOf("["));
    }

    public TestUnit updateTestUnit(TestUnit testUnit) {
        ITableModel dataModel = this.testSuite.getTestSuiteMethod().getBoundNode().getTable().getDataModel();
        ArrayList<IOpenField> fieldsToTest = new ArrayList<IOpenField>();
        IOpenClass resultType = this.testSuite.getTestedMethod().getType();
        Integer precision = null;
        for (ColumnDescriptor columnDescriptor : dataModel.getDescriptor()) {
            Object[] fieldSequence;
            IdentifierNode[] nodes;
            Integer fieldPrecision = null;
            if (columnDescriptor == null || (nodes = columnDescriptor.getFieldChainTokens()).length <= 0 || !nodes[0].getIdentifier().startsWith("_res_")) continue;
            if (columnDescriptor.isReference()) {
                if (resultType.isSimple()) continue;
                if (resultType.isArray()) {
                    WrapClassWithThisField arrayField = new WrapClassWithThisField(resultType);
                    fieldsToTest.add((IOpenField)arrayField);
                    continue;
                }
                fieldsToTest.addAll(resultType.getFields().values());
                continue;
            }
            boolean resIsArray = nodes[0].getIdentifier().matches(".+\\[[0-9]+\\]$");
            int startIndex = 0;
            Object currentType = resultType;
            if (resIsArray) {
                startIndex = 1;
                fieldSequence = new IOpenField[nodes.length];
                WrapClassWithThisField arrayField = new WrapClassWithThisField(resultType);
                int arrayIndex = TestUnitsResults.getArrayIndex(nodes[0]);
                DatatypeArrayElementField arrayAccessField = new DatatypeArrayElementField((IOpenField)arrayField, arrayIndex);
                currentType = arrayAccessField.getType().isArray() ? arrayAccessField.getType().getComponentClass() : arrayAccessField.getType();
                fieldSequence[0] = arrayAccessField;
            } else {
                fieldSequence = new IOpenField[nodes.length - 1];
            }
            if (fieldSequence.length == 0) continue;
            for (int i = startIndex; i < fieldSequence.length; ++i) {
                boolean isArray = nodes[i + 1 - startIndex].getIdentifier().matches(".+\\[[0-9]+\\]$");
                if (isArray) {
                    IOpenField arrayField = currentType.getField(TestUnitsResults.getArrayName(nodes[i + 1 - startIndex]));
                    if (arrayField == null && currentType.equals(JavaOpenClass.OBJECT) && nodes[i + 1 - startIndex].getIdentifier().matches("^\\$.+\\$.+$")) {
                        SpreadsheetResultOpenClass spreadsheetResultOpenClass = new SpreadsheetResultOpenClass(SpreadsheetResult.class);
                        arrayField = spreadsheetResultOpenClass.getField(TestUnitsResults.getArrayName(nodes[i + 1 - startIndex]));
                        currentType = spreadsheetResultOpenClass;
                    }
                    int arrayIndex = TestUnitsResults.getArrayIndex(nodes[i + 1 - startIndex]);
                    DatatypeArrayElementField arrayAccessField = new DatatypeArrayElementField(arrayField, arrayIndex);
                    fieldSequence[i] = arrayAccessField;
                } else {
                    SpreadsheetResultOpenClass spreadsheetResultOpenClass;
                    IOpenField openField;
                    fieldSequence[i] = currentType.getField(nodes[i + 1 - startIndex].getIdentifier());
                    if (fieldSequence[i] == null && (openField = (spreadsheetResultOpenClass = new SpreadsheetResultOpenClass(SpreadsheetResult.class)).getField(nodes[i + 1 - startIndex].getIdentifier())) != null) {
                        fieldSequence[i] = openField;
                        currentType = spreadsheetResultOpenClass;
                    }
                }
                if (fieldSequence[i] == null && nodes[i + 1 - startIndex].getIdentifier().matches("^\\(\\-?[0-9]+\\)$")) {
                    precision = fieldPrecision = DataTableBindHelper.getPrecisionValue(nodes[i + 1 - startIndex]);
                    fieldSequence = (IOpenField[])ArrayUtils.remove((Object[])fieldSequence, (int)i);
                    break;
                }
                currentType = fieldSequence[i].getType().isArray() && isArray ? fieldSequence[i].getType().getComponentClass() : fieldSequence[i].getType();
            }
            if (fieldSequence.length <= 0) continue;
            if (fieldSequence.length > 1 || fieldPrecision != null) {
                if (fieldPrecision != null) {
                    fieldsToTest.add((IOpenField)new PrecisionFieldChain((IOpenClass)currentType, (IOpenField[])fieldSequence, fieldPrecision));
                    continue;
                }
                fieldsToTest.add((IOpenField)new FieldChain((IOpenClass)currentType, (IOpenField[])fieldSequence));
                continue;
            }
            fieldsToTest.add(fieldSequence[0]);
        }
        if (fieldsToTest.size() > 0) {
            TestResultComparator resultComparator = TestResultComparatorFactory.getOpenLBeanComparator(fieldsToTest);
            testUnit.setTestUnitResultComparator(new TestUnitResultComparator(resultComparator));
        } else if (precision != null) {
            testUnit.setPrecision(precision);
        }
        return testUnit;
    }

    public void addTestUnits(List<TestUnit> testUnits) {
        this.testUnits.addAll(testUnits);
    }

    @Deprecated
    public Object getExpected(int i) {
        return this.testUnits.get(i).getExpectedResult();
    }

    public int getNumberOfFailures() {
        int cnt = 0;
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).compareResult() == TestUnitResultComparator.TestStatus.TR_OK.getStatus()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getNumberOfTestUnits() {
        return this.testUnits.size();
    }

    public boolean hasDescription() {
        for (TestUnit testUnit : this.testUnits) {
            if (testUnit.getTest().getDescription() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasContext() {
        for (TestUnit testUnit : this.testUnits) {
            if (!testUnit.getTest().isRuntimeContextDefined()) continue;
            return true;
        }
        return false;
    }

    public boolean isSpreadsheetResultTester() {
        return ClassUtils.isAssignable((Class)this.testSuite.getTestedMethod().getType().getInstanceClass(), SpreadsheetResult.class);
    }

    public boolean isRunmethod() {
        return this.testSuite.getTestSuiteMethod().isRunmethod();
    }

    @Deprecated
    public Object getUnitResult(int i) {
        return this.testUnits.get(i).getActualResult();
    }

    @Deprecated
    public Object getUnitDescription(int i) {
        return this.testUnits.get(i).getDescription();
    }

    public String[] getTestDataColumnDisplayNames() {
        String[] columnTechnicalNames = this.getTestDataColumnHeaders();
        String[] columnDisplayNames = new String[columnTechnicalNames.length];
        for (int i = 0; i < columnDisplayNames.length; ++i) {
            String displayName = this.testSuite.getTestSuiteMethod().getColumnDisplayName(columnTechnicalNames[i]);
            columnDisplayNames[i] = displayName != null ? displayName : columnTechnicalNames[i];
        }
        return columnDisplayNames;
    }

    private String[] getColumnDisplayNames(String type) {
        ArrayList<String> displayNames = new ArrayList<String>();
        TestSuiteMethod test = this.testSuite.getTestSuiteMethod();
        for (int i = 0; i < test.getColumnsCount(); ++i) {
            String columnName = test.getColumnName(i);
            if (columnName == null || !columnName.startsWith(type)) continue;
            displayNames.add(test.getColumnDisplayName(columnName));
        }
        return displayNames.toArray(new String[displayNames.size()]);
    }

    public String[] getContextColumnDisplayNames() {
        return this.getColumnDisplayNames("_context_");
    }

    public String[] getTestResultColumnDisplayNames() {
        return this.getColumnDisplayNames("_res_");
    }

    public String[] getTestDataColumnHeaders() {
        IMethodSignature testMethodSignature = this.testSuite.getTestedMethod().getSignature();
        int len = testMethodSignature.getParameterTypes().length;
        String[] res = new String[len];
        for (int i = 0; i < len; ++i) {
            res[i] = testMethodSignature.getParameterName(i);
        }
        return res;
    }

    @Deprecated
    public Object getTestValue(String fname, int i) {
        TestUnit testUnit = this.testUnits.get(i);
        return testUnit.getFieldValue(fname);
    }

    public StringBuilder printFailedUnits(StringBuilder sb) {
        sb.append(this.getName());
        if (this.getNumberOfFailures() == 0) {
            return sb.append(" - ").append(this.getNumberOfTestUnits()).append(" tests ALL OK!");
        }
        sb.append(" - ").append(this.getNumberOfTestUnits()).append(" tests / ").append(this.getNumberOfFailures()).append(" FAILED!");
        for (int i = 0; i < this.getNumberOfTestUnits(); ++i) {
            if (this.testUnits.get(i).compareResult() == TestUnitResultComparator.TestStatus.TR_OK.getStatus()) continue;
            sb.append('\n').append(i + 1).append(". ").append(this.testUnits.get(i).getDescription()).append("\t").append(this.testUnits.get(i).getExpectedResult()).append(" / ").append(this.testUnits.get(i).getActualResult());
        }
        return sb;
    }

    public String toString() {
        return this.printFailedUnits(new StringBuilder()).toString();
    }

    private class WrapClassWithThisField
    extends AOpenField {
        protected WrapClassWithThisField(IOpenClass clazz) {
            super("this", clazz);
        }

        public Object get(Object target, IRuntimeEnv env) {
            return target;
        }

        public void set(Object target, Object value, IRuntimeEnv env) {
            throw new RuntimeException("Can not assign to 'this'");
        }
    }
}

