/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.data.PrecisionFieldChain;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.rules.testmethod.TestUnitResultComparator;
import org.openl.rules.testmethod.result.ComparedResult;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class BeanResultComparator
implements TestResultComparator {
    private List<IOpenField> fields;
    private List<ComparedResult> comparisonResults = new ArrayList<ComparedResult>();

    public BeanResultComparator(List<IOpenField> fields) {
        this.fields = fields;
    }

    public List<ComparedResult> getComparisonResults() {
        return this.comparisonResults;
    }

    public List<ComparedResult> getExceptionResults(Throwable actualResult, Object expectedResult) {
        if (this.comparisonResults.isEmpty()) {
            ArrayList<ComparedResult> results = new ArrayList<ComparedResult>();
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)actualResult);
            if (rootCause == null) {
                rootCause = actualResult;
            }
            String actualFieldValue = rootCause instanceof OpenLUserRuntimeException ? ((OpenLUserRuntimeException)((Object)rootCause)).getOriginalMessage() : rootCause.getMessage();
            for (IOpenField field : this.fields) {
                ComparedResult fieldComparisonResults = new ComparedResult();
                fieldComparisonResults.setFieldName(field.getName());
                fieldComparisonResults.setActualValue(actualFieldValue);
                fieldComparisonResults.setExpectedValue(this.getFieldValueOrNull(expectedResult, field));
                fieldComparisonResults.setStatus(TestUnitResultComparator.TestStatus.TR_NEQ);
                results.add(fieldComparisonResults);
            }
            this.comparisonResults = results;
        }
        return this.comparisonResults;
    }

    @Override
    public boolean compareResult(Object actualResult, Object expectedResult, Double delta) {
        boolean success = true;
        if (actualResult == null || expectedResult == null) {
            for (IOpenField field : this.fields) {
                boolean equal;
                Object actualFieldValue = this.getFieldValueOrNull(actualResult, field);
                Object expectedFieldValue = this.getFieldValueOrNull(expectedResult, field);
                boolean bl = equal = actualFieldValue == null && expectedFieldValue == null;
                if (!equal) {
                    success = false;
                }
                ComparedResult fieldComparisonResults = new ComparedResult();
                fieldComparisonResults.setFieldName(field.getName());
                fieldComparisonResults.setActualValue(actualFieldValue);
                fieldComparisonResults.setExpectedValue(expectedFieldValue);
                fieldComparisonResults.setStatus(equal ? TestUnitResultComparator.TestStatus.TR_OK : TestUnitResultComparator.TestStatus.TR_NEQ);
                this.comparisonResults.add(fieldComparisonResults);
            }
        } else {
            this.comparisonResults = new ArrayList<ComparedResult>();
            for (IOpenField field : this.fields) {
                Object actualFieldValue = this.getFieldValueOrNull(actualResult, field);
                Object expectedFieldValue = this.getFieldValueOrNull(expectedResult, field);
                ComparedResult fieldComparisonResults = new ComparedResult();
                fieldComparisonResults.setFieldName(field.getName());
                Double columnDelta = delta;
                if (field instanceof PrecisionFieldChain && ((PrecisionFieldChain)field).hasDelta()) {
                    columnDelta = ((PrecisionFieldChain)field).getDelta();
                }
                boolean compare = false;
                try {
                    if (expectedFieldValue != null && actualFieldValue != null && expectedFieldValue.getClass() != actualFieldValue.getClass() && expectedResult instanceof SpreadsheetResult && expectedFieldValue instanceof String) {
                        IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(actualFieldValue.getClass());
                        expectedFieldValue = convertor.parse((String)expectedFieldValue, null);
                    }
                    TestResultComparator comparator = TestResultComparatorFactory.getComparator(actualFieldValue, expectedFieldValue);
                    compare = comparator.compareResult(actualFieldValue, expectedFieldValue, columnDelta);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fieldComparisonResults.setActualValue(actualFieldValue);
                fieldComparisonResults.setExpectedValue(expectedFieldValue);
                if (!compare) {
                    fieldComparisonResults.setStatus(TestUnitResultComparator.TestStatus.TR_NEQ);
                    success = false;
                } else {
                    fieldComparisonResults.setStatus(TestUnitResultComparator.TestStatus.TR_OK);
                }
                this.comparisonResults.add(fieldComparisonResults);
            }
        }
        return success;
    }

    private Object getFieldValueOrNull(Object result, IOpenField field) {
        Object fieldValue = null;
        if (result != null) {
            try {
                IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
                fieldValue = field.get(result, env);
            }
            catch (Exception ex) {
                fieldValue = ex;
            }
        }
        return fieldValue;
    }
}

