/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.OpenL;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.validation.ValidationUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;

public class DimentionalPropertyValidator
implements IOpenLValidator {
    public ValidationResult validate(OpenL openl, IOpenClass openClass) {
        ValidationResult validationResult = null;
        Set<String> dimensionalProperties = this.getDimensionalProperties();
        for (IOpenMethod method : openClass.getMethods()) {
            if (!(method instanceof OpenMethodDispatcher)) continue;
            OpenMethodDispatcher openMethodDispatcher = (OpenMethodDispatcher)method;
            IOpenMethod[] methods = openMethodDispatcher.getCandidates().toArray(new IOpenMethod[0]);
            for (int i = 0; i < methods.length - 1; ++i) {
                ITableProperties propsA = PropertiesHelper.getTableProperties(methods[i]);
                Map<String, Object> propertiesA = propsA.getAllProperties();
                for (int j = i + 1; j < methods.length; ++j) {
                    OverlapState overlapState = OverlapState.UNKNOWN;
                    HashMap<OverlapState, String> vResult = new HashMap<OverlapState, String>();
                    ITableProperties propsB = PropertiesHelper.getTableProperties(methods[j]);
                    Map<String, Object> propertiesB = propsB.getAllProperties();
                    HashSet<String> propKeys = new HashSet<String>();
                    propKeys.addAll(propertiesA.keySet());
                    propKeys.addAll(propertiesB.keySet());
                    for (String propKey : propKeys) {
                        if (!dimensionalProperties.contains(propKey)) continue;
                        Object prop = propertiesA.get(propKey);
                        Object p = propertiesB.get(propKey);
                        if (prop == null && p == null) continue;
                        if (!OverlapState.OVERLAP.equals((Object)overlapState)) {
                            if (prop == null) {
                                overlapState = OverlapState.INCLUDE_TO_B.equals((Object)overlapState) ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_A;
                                vResult.put(OverlapState.INCLUDE_TO_A, propKey);
                                continue;
                            }
                            if (p == null) {
                                overlapState = OverlapState.INCLUDE_TO_A.equals((Object)overlapState) ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_B;
                                vResult.put(OverlapState.INCLUDE_TO_B, propKey);
                                continue;
                            }
                        } else if (prop == null || p == null) continue;
                        if (prop.getClass().isArray()) {
                            HashSet<Object> propSet = new HashSet<Object>();
                            int length = Array.getLength(prop);
                            for (int k = 0; k < length; ++k) {
                                propSet.add(Array.get(prop, k));
                            }
                            HashSet<Object> pSet = new HashSet<Object>();
                            length = Array.getLength(p);
                            for (int k = 0; k < length; ++k) {
                                pSet.add(Array.get(p, k));
                            }
                            boolean f1 = false;
                            boolean f2 = false;
                            if (!OverlapState.OVERLAP.equals((Object)overlapState)) {
                                f1 = propSet.containsAll(pSet);
                                f2 = pSet.containsAll(propSet);
                            }
                            propSet.retainAll(pSet);
                            boolean f3 = propSet.isEmpty();
                            if (f3) {
                                overlapState = OverlapState.NOT_OVERLAP;
                                break;
                            }
                            if (OverlapState.OVERLAP.equals((Object)overlapState) || f1 && f2) continue;
                            if (f1) {
                                overlapState = OverlapState.INCLUDE_TO_B.equals((Object)overlapState) ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_A;
                                vResult.put(OverlapState.INCLUDE_TO_A, propKey);
                                continue;
                            }
                            if (f2) {
                                overlapState = OverlapState.INCLUDE_TO_A.equals((Object)overlapState) ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_B;
                                vResult.put(OverlapState.INCLUDE_TO_B, propKey);
                                continue;
                            }
                            overlapState = OverlapState.OVERLAP;
                            vResult.put(OverlapState.OVERLAP, propKey);
                            continue;
                        }
                        if (prop.equals(p)) continue;
                        overlapState = OverlapState.NOT_OVERLAP;
                        break;
                    }
                    if (overlapState != OverlapState.OVERLAP) continue;
                    if (validationResult == null) {
                        validationResult = new ValidationResult(ValidationStatus.SUCCESS);
                    }
                    StringBuilder sb = new StringBuilder();
                    if (vResult.containsKey((Object)OverlapState.OVERLAP)) {
                        String pKey = (String)vResult.get((Object)OverlapState.OVERLAP);
                        Object valueA = propertiesA.get(pKey);
                        Object valueB = propertiesB.get(pKey);
                        sb.append("(");
                        this.writeMessageforProperty(sb, pKey, valueA);
                        sb.append(")");
                        sb.append(" and ");
                        sb.append("(");
                        this.writeMessageforProperty(sb, pKey, valueB);
                        sb.append(")");
                    } else {
                        String pKey1 = (String)vResult.get((Object)OverlapState.INCLUDE_TO_A);
                        Object value1A = propertiesA.get(pKey1);
                        Object value1B = propertiesB.get(pKey1);
                        String pKey2 = (String)vResult.get((Object)OverlapState.INCLUDE_TO_B);
                        Object value2A = propertiesA.get(pKey2);
                        Object value2B = propertiesB.get(pKey2);
                        sb.append("(");
                        this.writeMessageforProperty(sb, pKey1, value1A);
                        sb.append(", ");
                        this.writeMessageforProperty(sb, pKey2, value2A);
                        sb.append(")");
                        sb.append(" and ");
                        sb.append("(");
                        this.writeMessageforProperty(sb, pKey1, value1B);
                        sb.append(", ");
                        this.writeMessageforProperty(sb, pKey2, value2B);
                        sb.append(")");
                    }
                    this.addValidationError(validationResult, sb.toString(), methods[i]);
                    this.addValidationError(validationResult, sb.toString(), methods[j]);
                }
            }
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private void writeMessageforProperty(StringBuilder sb, String pKey, Object value) {
        sb.append(pKey);
        sb.append("={");
        if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int k = 0; k < length; ++k) {
                    if (k != 0) {
                        sb.append(", ");
                    }
                    this.writeObject(sb, Array.get(value, k));
                }
            } else {
                this.writeObject(sb, value);
            }
        }
        sb.append("}");
    }

    private void writeObject(StringBuilder sb, Object value) {
        if (value.getClass().isEnum()) {
            sb.append(((Enum)value).name());
        } else {
            sb.append(value.toString());
        }
    }

    private Set<String> getDimensionalProperties() {
        String[] dPropertiesArray = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
        HashSet<String> dProperties = new HashSet<String>();
        for (String d : dPropertiesArray) {
            dProperties.add(d);
        }
        return dProperties;
    }

    private void addValidationError(ValidationResult validationResult, String message, IOpenMethod method) {
        IMemberMetaInfo memberMetaInfo = (IMemberMetaInfo)method;
        if (memberMetaInfo.getSyntaxNode() != null && memberMetaInfo.getSyntaxNode() instanceof TableSyntaxNode) {
            ValidationUtils.addValidationMessage(validationResult, (OpenLMessage)new OpenLWarnMessage("Ambiguous definition of properties values. Details: " + message, memberMetaInfo.getSyntaxNode()));
        }
    }

    private static enum OverlapState {
        OVERLAP,
        INCLUDE_TO_A,
        INCLUDE_TO_B,
        NOT_OVERLAP,
        UNKNOWN;

    }
}

