/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.vm;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;

class Storage {
    private final Map<Object, SimpleRulesRuntimeEnv.Data> storage = new WeakHashMap<Object, SimpleRulesRuntimeEnv.Data>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    Storage() {
    }

    public SimpleRulesRuntimeEnv.Data get(Object key) {
        this.readLock.lock();
        try {
            SimpleRulesRuntimeEnv.Data data = this.storage.get(key);
            return data;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleRulesRuntimeEnv.Data put(Object key, SimpleRulesRuntimeEnv.Data data) {
        this.writeLock.lock();
        try {
            SimpleRulesRuntimeEnv.Data data2 = this.storage.put(key, data);
            return data2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.storage.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

