/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.mutation;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.solution.Solution;

public class MutationCounter {
    protected final SolutionDescriptor solutionDescriptor;

    public MutationCounter(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public int countMutations(Solution a, Solution b) {
        int mutationCount = 0;
        for (PlanningEntityDescriptor entityDescriptor : this.solutionDescriptor.getGenuineEntityDescriptors()) {
            List<Object> aEntities = entityDescriptor.extractEntities(a);
            List<Object> bEntities = entityDescriptor.extractEntities(b);
            Iterator<Object> aIt = aEntities.iterator();
            Iterator<Object> bIt = bEntities.iterator();
            while (aIt.hasNext() && bIt.hasNext()) {
                Object aEntity = aIt.next();
                Object bEntity = bIt.next();
                for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getVariableDescriptors()) {
                    if (variableDescriptor.getValue(aEntity) == variableDescriptor.getValue(bEntity)) continue;
                    ++mutationCount;
                }
            }
            if (aEntities.size() == bEntities.size()) continue;
            mutationCount += Math.abs(aEntities.size() - bEntities.size()) * entityDescriptor.getVariableDescriptors().size();
        }
        return mutationCount;
    }
}

