/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SwapMove
implements Move {
    protected final Collection<PlanningVariableDescriptor> variableDescriptors;
    protected final Object leftEntity;
    protected final Object rightEntity;

    public SwapMove(Collection<PlanningVariableDescriptor> variableDescriptors, Object leftEntity, Object rightEntity) {
        this.variableDescriptors = variableDescriptors;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object rightValue;
            Object leftValue = variableDescriptor.getValue(this.leftEntity);
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = variableDescriptor.getValue(this.rightEntity)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SwapMove(this.variableDescriptors, this.rightEntity, this.leftEntity);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (ObjectUtils.equals((Object)oldLeftValue, (Object)(oldRightValue = variableDescriptor.getValue(this.rightEntity)))) continue;
            scoreDirector.beforeVariableChanged(this.leftEntity, variableDescriptor.getVariableName());
            variableDescriptor.setValue(this.leftEntity, oldRightValue);
            scoreDirector.afterVariableChanged(this.leftEntity, variableDescriptor.getVariableName());
            scoreDirector.beforeVariableChanged(this.rightEntity, variableDescriptor.getVariableName());
            variableDescriptor.setValue(this.rightEntity, oldLeftValue);
            scoreDirector.afterVariableChanged(this.rightEntity, variableDescriptor.getVariableName());
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.variableDescriptors.size() * 2);
        for (PlanningVariableDescriptor variableDescriptor : this.variableDescriptors) {
            values.add(variableDescriptor.getValue(this.leftEntity));
            values.add(variableDescriptor.getValue(this.rightEntity));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SwapMove) {
            SwapMove other = (SwapMove)o;
            return new EqualsBuilder().append(this.leftEntity, other.leftEntity).append(this.rightEntity, other.rightEntity).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftEntity).append(this.rightEntity).toHashCode();
    }

    public String toString() {
        return this.leftEntity + " <=> " + this.rightEntity;
    }
}

