/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.simulatedannealing;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.ScoreUtils;

public class LegacySimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected double startingTemperature = -1.0;
    protected double temperatureSurvival = 0.997;
    protected double temperature;

    public void setStartingTemperature(double startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void setTemperatureSurvival(double temperatureSurvival) {
        this.temperatureSurvival = temperatureSurvival;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        if (this.startingTemperature <= 0.0) {
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot be negative or zero.");
        }
        if (this.temperatureSurvival <= 0.0) {
            throw new IllegalArgumentException("The temperatureSurvival (" + this.temperatureSurvival + ") cannot be negative or zero.");
        }
        this.temperature = this.startingTemperature;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        LocalSearchSolverPhaseScope phaseScope = moveScope.getStepScope().getPhaseScope();
        Score lastStepScore = phaseScope.getLastCompletedStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) > 0) {
            return true;
        }
        Score moveScoreDifference = lastStepScore.subtract(moveScore);
        double[] moveScoreDifferenceLevels = ScoreUtils.extractLevelDoubles(moveScoreDifference);
        for (int i = 0; i < moveScoreDifferenceLevels.length - 1; ++i) {
            if (moveScoreDifferenceLevels[i] == 0.0) continue;
            return false;
        }
        double diff = moveScoreDifferenceLevels[moveScoreDifferenceLevels.length - 1];
        double acceptChance = Math.exp(-diff / this.temperature);
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.temperature *= this.temperatureSurvival;
    }
}

