/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableBigDecimalScoreHolder
extends AbstractScoreHolder {
    private BigDecimal[] hardScores;
    private BigDecimal[] softScores;

    public BendableBigDecimalScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public BigDecimal getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    @Deprecated
    public void setHardScore(int hardLevel, BigDecimal hardScore) {
        this.hardScores[hardLevel] = hardScore;
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public BigDecimal getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Deprecated
    public void setSoftScore(int softLevel, BigDecimal softScore) {
        this.softScores[softLevel] = softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final int hardLevel, final BigDecimal weight) {
        this.hardScores[hardLevel] = this.hardScores[hardLevel].add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, hardLevel, weight, new AbstractScoreHolder.BigDecimalConstraintUndoListener(){

            @Override
            public void undo() {
                ((BendableBigDecimalScoreHolder)BendableBigDecimalScoreHolder.this).hardScores[hardLevel] = BendableBigDecimalScoreHolder.this.hardScores[hardLevel].subtract(weight);
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final int softLevel, final BigDecimal weight) {
        this.softScores[softLevel] = this.softScores[softLevel].add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, this.getHardLevelsSize() + softLevel, weight, new AbstractScoreHolder.BigDecimalConstraintUndoListener(){

            @Override
            public void undo() {
                ((BendableBigDecimalScoreHolder)BendableBigDecimalScoreHolder.this).softScores[softLevel] = BendableBigDecimalScoreHolder.this.softScores[softLevel].subtract(weight);
            }
        });
    }

    @Override
    public Score extractScore() {
        return new BendableBigDecimalScore(Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

