/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.EmptySolverFactory;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;

public abstract class SolverFactory<Solution_ extends Solution> {
    public static <Solution_ extends Solution> SolverFactory<Solution_> createEmpty() {
        return new EmptySolverFactory();
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createEmpty(ClassLoader classLoader) {
        return new EmptySolverFactory(new SolverConfigContext(classLoader));
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromKieContainerXmlResource(String solverConfigResource) {
        KieContainer kieContainer = KieServices.Factory.get().getKieClasspathContainer();
        return new XStreamXmlSolverFactory(new SolverConfigContext(kieContainer)).configure(solverConfigResource);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromKieContainerXmlResource(ReleaseId releaseId, String solverConfigResource) {
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        return SolverFactory.createFromKieContainerXmlResource(kieContainer, solverConfigResource);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromKieContainerXmlResource(KieContainer kieContainer, String solverConfigResource) {
        return new XStreamXmlSolverFactory(new SolverConfigContext(kieContainer)).configure(solverConfigResource);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlResource(String solverConfigResource) {
        return new XStreamXmlSolverFactory().configure(solverConfigResource);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlResource(String solverConfigResource, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(new SolverConfigContext(classLoader)).configure(solverConfigResource);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlFile(File solverConfigFile) {
        return new XStreamXmlSolverFactory().configure(solverConfigFile);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlFile(File solverConfigFile, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(new SolverConfigContext(classLoader)).configure(solverConfigFile);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlInputStream(InputStream in) {
        return new XStreamXmlSolverFactory().configure(in);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(new SolverConfigContext(classLoader)).configure(in);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlReader(Reader reader) {
        return new XStreamXmlSolverFactory().configure(reader);
    }

    public static <Solution_ extends Solution> SolverFactory<Solution_> createFromXmlReader(Reader reader, ClassLoader classLoader) {
        return new XStreamXmlSolverFactory(new SolverConfigContext(classLoader)).configure(reader);
    }

    public abstract SolverConfig getSolverConfig();

    public abstract SolverFactory<Solution_> cloneSolverFactory();

    public abstract Solver<Solution_> buildSolver();
}

