/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.CollectionInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.CollectionInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class InverseRelationShadowVariableDescriptor
extends ShadowVariableDescriptor {
    protected VariableDescriptor sourceVariableDescriptor;
    protected boolean singleton;

    public InverseRelationShadowVariableDescriptor(EntityDescriptor entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        boolean chained;
        Class masterClass;
        InverseRelationShadowVariable shadowVariableAnnotation = this.variableMemberAccessor.getAnnotation(InverseRelationShadowVariable.class);
        Class variablePropertyType = this.getVariablePropertyType();
        if (Collection.class.isAssignableFrom(variablePropertyType)) {
            Type genericType = this.variableMemberAccessor.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a property type (" + variablePropertyType + ") which is non parameterized collection.");
            }
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a property type (" + variablePropertyType + ") which is parameterized collection with an unsupported number of type arguments (" + typeArguments.length + ").");
            }
            Type typeArgument = typeArguments[0];
            if (!(typeArgument instanceof Class)) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a property type (" + variablePropertyType + ") which is parameterized collection with an unsupported type arguments (" + typeArgument + ").");
            }
            masterClass = (Class)typeArgument;
            this.singleton = false;
        } else {
            masterClass = variablePropertyType;
            this.singleton = true;
        }
        EntityDescriptor sourceEntityDescriptor = this.getEntityDescriptor().getSolutionDescriptor().findEntityDescriptor(masterClass);
        if (sourceEntityDescriptor == null) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a masterClass (" + masterClass + ") which is not a valid planning entity.");
        }
        String sourceVariableName = shadowVariableAnnotation.sourceVariableName();
        this.sourceVariableDescriptor = sourceEntityDescriptor.getVariableDescriptor(sourceVariableName);
        if (this.sourceVariableDescriptor == null) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on entityClass (" + sourceEntityDescriptor.getEntityClass() + ").\n" + this.entityDescriptor.buildInvalidVariableNameExceptionMessage(sourceVariableName));
        }
        boolean bl = chained = this.sourceVariableDescriptor instanceof GenuineVariableDescriptor && ((GenuineVariableDescriptor)this.sourceVariableDescriptor).isChained();
        if (this.singleton) {
            if (!chained) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") which does not return a " + Collection.class.getSimpleName() + " with sourceVariableName (" + sourceVariableName + ") which is not chained. Only a chained variable supports a singleton inverse.");
            }
        } else if (chained) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a " + InverseRelationShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") which does returns a " + Collection.class.getSimpleName() + " with sourceVariableName (" + sourceVariableName + ") which is chained. A chained variable supports only a singleton inverse.");
        }
        this.sourceVariableDescriptor.registerSinkVariableDescriptor(this);
    }

    @Override
    public List<VariableDescriptor> getSourceVariableDescriptorList() {
        return Collections.singletonList(this.sourceVariableDescriptor);
    }

    @Override
    public Demand getProvidedDemand() {
        if (this.singleton) {
            return new SingletonInverseVariableDemand(this.sourceVariableDescriptor);
        }
        return new CollectionInverseVariableDemand(this.sourceVariableDescriptor);
    }

    @Override
    public VariableListener buildVariableListener(InnerScoreDirector scoreDirector) {
        if (this.singleton) {
            return new SingletonInverseVariableListener(this, this.sourceVariableDescriptor);
        }
        return new CollectionInverseVariableListener(this, this.sourceVariableDescriptor);
    }
}

